#!/bin/bash

# Copyright (C) since 2006 NTT DATA Corporation
# 
# This program is free software; you can redistribute it and/or
# Modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation, version 2.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details

# bash configuration
SCRIPT_DIR=$(cd $(dirname $0);pwd)
. ${SCRIPT_DIR}/../../hinemos.cfg
. ${SCRIPT_DIR}/../hinemos_utility.sh

DIR=`dirname $0`
USER=`/usr/bin/whoami`
HOST=`hostname`

########################################
#  Local Variable
########################################
DBPORT=24001
DBNAME=hinemos
DBUSER=hinemos

DUMP_PATH="."
PGDUMP_FILE_BASE="hinemos_pgdump"

DATE=`date "+%Y-%m-%d_%H%M%S"`

########################################
#  Local Message
########################################

# INFO
MSG_I001="dumping data stored in Hinemos RDBMS Server (PostgreSQL)..."
MSG_I002="   output file : "
MSG_I101="successful in dumping data."

# WARN
MSG_W001="output file already exists. remove it and try again."

# ERROR
MSG_E001="failed to execute pg_dump command."
MSG_E002="failed to dump data."

########################################
# Function
########################################

#
# show usage
#
function usage {
	echo "usage : ${PROG} [-w] [password]"
	echo "options:"
	echo "  -w passwd  set password (for Hinemos RDBM Server)"
}

#
# dump data of PostgreSQL
#
function dump_postgresql {
	AskPostgreSQLPasswd
	
	DUMP_FILE="${DUMP_PATH}/${PGDUMP_FILE_BASE}.${DATE}"
	
	Logging "${MSG_I001}"
	Logging "${MSG_I002}`pwd`/${PGDUMP_FILE_BASE}.${DATE}"
	
	if [ -e ${DUMP_FILE} ]
	then
		Logging "${MSG_W001}"
		return 4
	fi
	
	MSG=`${PG_HOME}/bin/pg_dump -U ${DBUSER} -p ${DBPORT} ${DBNAME} -f ${DUMP_FILE} -C 2>&1`
	RET=$?
	if [ ${RET} -ne 0 ]
	then
		Logging "${MSG}"
		Logging "${MSG_E001}"
		RET=$((16 + ${RET}))
		return ${RET}
	fi
	
	return 0
}

########################################
# SHELL
########################################

# check parameters
for OPT in $@
do
	case $OPT in
		--help)
			usage
			exit 0
			;;
	esac
done


# option check
while getopts w: OPT
do
	case $OPT in
		w)
			export PGPASSWORD=${OPTARG}
			;;
		*)
			ExitIllegalOptionErrorWithoutLogger
			;;
	esac
done

shift $(( $OPTIND - 1 ))

if [ ! $# = 0 ]
then
	ExitIllegalArgumentError
fi

# check user
CheckUser ${JVM_USER}

# check process
CheckPostgreSQLProcessRunning

# main
dump_postgresql
RET=$?
if [ ${RET} -ne 0 ]
then
	Logging "${MSG_E002}"
	exit ${RET}
fi

########################################
# Termination Processing
########################################

Logging "${MSG_I101}"
exit ${RET}
