#!/bin/sh

# Copyright (C) since 2006 NTT DATA Corporation
# 
# This program is free software; you can redistribute it and/or
# Modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation, version 2.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details

# bash configuration
SCRIPT_DIR=$(cd $(dirname $0);pwd)
. ${SCRIPT_DIR}/../hinemos.cfg
. ${SCRIPT_DIR}/../sbin/hinemos_utility.sh

export PROG=`basename $0`
DIR=`dirname $0`
USER=`/usr/bin/whoami`
HOST=`hostname`

cd ${HINEMOS_HOME}/var/log

########################################
#  Local Variable
########################################

# timeout [sec] (pg_ctl -t option)
#   this variable is valid with -W option
PG_TIMEOUT=90

########################################
#  Local Message
########################################

# INFO
MSG_I001="waiting for PostgreSQL startup..."
MSG_I002="PostgreSQL started"

# WARN
MSG_W001="xxx"

# ERROR
MSG_E001="failed to start PostgreSQL"

########################################
# Function
########################################

function usage {
	echo "usage : ${PROG} [-F]"
	echo "options:"
	echo "  -F   force immediate shutdown without process check (dependency, current status)"
}

function startup {
	Logging "${MSG_I001}"
	su -c ". ${HINEMOS_HOME}/hinemos.cfg && ${PG_HOME}/bin/pg_ctl start -w -t ${PG_TIMEOUT} -s -D ${PG_DATA} -l ${PG_LOGFILE}" - ${PG_USER}
	RET=$?
	
	if [ ${RET} -eq 0 ]
	then
		Logging "${MSG_I002}"
	else
		Logging "${MSG_E001}"
	fi
	return ${RET}
}

########################################
# SHELL
########################################

# check argument
for OPT in $@
do
	case ${OPT} in
		--help)
			usage
			exit 0
			;;
	esac
done

# option check
FORCE="false"
while getopts F OPT
do
	case ${OPT} in
		F)
			FORCE="true"
			;;
		*)
			ExitIllegalOptionErrorWithoutLogger
			;;
	esac
done

shift $(( $OPTIND - 1 ))

if [ ! $# = 0 ]
then
	ExitIllegalArgumentError
fi

# check user executed
CheckUser ${JVM_USER}

if [ "x${FORCE}" != "xtrue" ]
then
	CheckPostgreSQLProcessStopped
fi

# startup PostgreSQL
startup

exit $?
