#!/bin/bash

# Copyright (C) since 2006 NTT DATA Corporation
# 
# This program is free software; you can redistribute it and/or
# Modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation, version 2.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details

# bash configuration
SCRIPT_DIR=$(cd $(dirname $0);pwd)
. ${SCRIPT_DIR}/../hinemos.cfg
. ${SCRIPT_DIR}/../sbin/hinemos_utility.sh

export PROG=`basename $0`
DIR=`dirname $0`
USER=`/usr/bin/whoami`
HOST=`hostname`

########################################
#  Local Variable
########################################


########################################
#  Local Message
########################################

# INFO
MSG_I001="waiting for Hinemos Manager to start..."
MSG_I002="Hinemos Manager started"

# WARN
#MSG_W001="xxx"

# ERROR
MSG_E001="failed to start Hinemos Manager"

########################################
# Function
########################################

function usage {
	echo "usage : ${PROG} [-c|-M|-W]"
	echo "options:"
	echo "  -c   clean temporally queue data before startup"
	echo "  -M   startup maintenance mode"
	echo "  -W   do not wait until operation completes"
}

########################################
# SHELL
########################################

# check argument
for OPT in $@
do
	case ${OPT} in
		--help)
			usage
			exit 0
			;;
	esac
done

# option check
JVM_START_OPTS=""
while getopts cMW OPT
do
	case ${OPT} in
		c)
			JVM_START_OPTS="${JVM_START_OPTS} -c"
			;;
		M)
			JVM_START_OPTS="${JVM_START_OPTS} -M"
			;;
		W)
			JVM_START_OPTS="${JVM_START_OPTS} -W"
			;;
		*)
			ExitIllegalOptionErrorWithoutLogger
			;;
	esac
done

shift $(( $OPTIND - 1 ))

if [ ! $# = 0 ]
then
	ExitIllegalArgumentError
fi

# check user executed
CheckUser ${JVM_USER}

Logging "${MSG_I001}"
echo

# startup PostgreSQL
${HINEMOS_HOME}/bin/pg_start.sh

RET=$?
if [ ${RET} -ne 0 ]
then
	echo
	Logging "${MSG_E001}"
	exit ${RET}
fi

# startup JVM
echo
${HINEMOS_HOME}/bin/jvm_start.sh ${JVM_START_OPTS}

RET=$?
if [ ${RET} -ne 0 ]
then
	echo
	Logging "${MSG_E001}"
	exit ${RET}
fi

echo
Logging "${MSG_I002}"

exit 0

