/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.DeleteClause;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.FullyQualifyPathExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.WhereClause;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeleteStatement
extends AbstractExpression {
    private DeleteClause deleteClause;
    private boolean hasSpace;
    private AbstractExpression whereClause;

    public DeleteStatement(AbstractExpression parent) {
        super(parent);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getDeleteClause().accept(visitor);
        this.getWhereClause().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getDeleteClause());
        children.add(this.getWhereClause());
    }

    public DeleteClause addDeleteClause() {
        this.deleteClause = new DeleteClause(this);
        return this.deleteClause;
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        children.add(this.deleteClause);
        if (this.hasSpace) {
            children.add(this.buildStringExpression(' '));
        }
        children.add(this.whereClause);
    }

    @Override
    public JPQLQueryBNF findQueryBNF(Expression expression) {
        if (this.deleteClause != null && this.deleteClause.isAncestor(expression)) {
            return this.getQueryBNF("delete_clause");
        }
        if (this.whereClause != null && this.whereClause.isAncestor(expression)) {
            return this.getQueryBNF("where_clause");
        }
        return super.findQueryBNF(expression);
    }

    public DeleteClause getDeleteClause() {
        return this.deleteClause;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("delete_statement");
    }

    public Expression getWhereClause() {
        if (this.whereClause == null) {
            this.whereClause = this.buildNullExpression();
        }
        return this.whereClause;
    }

    public boolean hasSpaceAfterDeleteClause() {
        return this.hasSpace;
    }

    public boolean hasWhereClause() {
        return this.whereClause != null && !this.whereClause.isNull();
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        this.deleteClause = new DeleteClause(this);
        this.deleteClause.parse(wordParser, tolerant);
        boolean bl = this.hasSpace = wordParser.skipLeadingWhitespace() > 0;
        if (wordParser.startsWithIdentifier("WHERE")) {
            this.whereClause = new WhereClause(this);
            this.whereClause.parse(wordParser, tolerant);
        }
        this.accept(new FullyQualifyPathExpressionVisitor());
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        this.deleteClause.toParsedText(writer, actual);
        if (this.hasSpace) {
            writer.append(' ');
        }
        if (this.whereClause != null) {
            this.whereClause.toParsedText(writer, actual);
        }
    }
}

