/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.security.authentication.jaas;

import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLoginModule<P extends Principal>
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private P principal;

    @Override
    public final void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.postConstruct(subject, callbackHandler, sharedState, options);
    }

    protected void postConstruct(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
    }

    public P getCurrentPrincipal() {
        return this.principal;
    }

    @Override
    public final boolean login() throws LoginException {
        try {
            this.principal = null;
            Callback[] callbacks = new Callback[]{new NameCallback("Username"), new PasswordCallback("Password", false)};
            this.callbackHandler.handle(callbacks);
            String username = ((NameCallback)callbacks[0]).getName();
            String password = new String(((PasswordCallback)callbacks[1]).getPassword());
            this.principal = this.authenticate(username, password);
        }
        catch (IOException e) {
            throw (LoginException)new LoginException().initCause(e);
        }
        catch (UnsupportedCallbackException e) {
            throw (LoginException)new LoginException().initCause(e);
        }
        return this.principal != null;
    }

    protected abstract P authenticate(String var1, String var2) throws LoginException;

    @Override
    public final boolean logout() throws LoginException {
        if (this.canLogout()) {
            this.principal = null;
        }
        return this.principal == null;
    }

    protected boolean canLogout() {
        return true;
    }

    @Override
    public final boolean commit() throws LoginException {
        if (this.principal == null) {
            return false;
        }
        this.subject.getPrincipals().add((Principal)this.principal);
        Principal[] additionalPrincipals = this.getAdditionalPrincipals();
        if (additionalPrincipals != null) {
            for (Principal additionalPrincipal : this.getAdditionalPrincipals()) {
                this.subject.getPrincipals().add(additionalPrincipal);
            }
        }
        return true;
    }

    protected Principal[] getAdditionalPrincipals() {
        return new Principal[0];
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.principal == null) {
            return false;
        }
        return this.logout();
    }
}

