/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.security.authentication;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sf.jpasecurity.configuration.AuthenticationProvider;
import net.sf.jpasecurity.configuration.AuthenticationProviderSecurityContext;
import net.sf.jpasecurity.configuration.Configuration;
import net.sf.jpasecurity.configuration.ConfigurationReceiver;
import net.sf.jpasecurity.configuration.SecurityContext;
import net.sf.jpasecurity.configuration.SecurityContextReceiver;
import net.sf.jpasecurity.mapping.Alias;
import net.sf.jpasecurity.mapping.MappingInformation;
import net.sf.jpasecurity.mapping.MappingInformationReceiver;
import net.sf.jpasecurity.security.authentication.DefaultAuthenticationProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutodetectingSecurityContext
implements SecurityContext,
ConfigurationReceiver,
MappingInformationReceiver,
SecurityContextReceiver {
    private static final Log LOG = LogFactory.getLog(AutodetectingSecurityContext.class);
    private static final List<String> AUTHENTICATION_PROVIDER_CLASS_NAMES;
    private AuthenticationProviderSecurityContext securityContext = new AuthenticationProviderSecurityContext(this.autodetectAuthenticationProvider());

    protected AuthenticationProvider autodetectAuthenticationProvider() {
        for (String providerClassName : AUTHENTICATION_PROVIDER_CLASS_NAMES) {
            try {
                ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
                Class<?> authenticationProviderClass = currentClassLoader.loadClass(providerClassName);
                LOG.info((Object)("autodetected presence of class " + providerClassName));
                AuthenticationProvider authenticationProvider = (AuthenticationProvider)authenticationProviderClass.newInstance();
                LOG.info((Object)("using " + providerClassName));
                return authenticationProvider;
            }
            catch (IllegalAccessException e) {
                throw new SecurityException(e);
            }
            catch (ClassNotFoundException e) {
            }
            catch (InstantiationException e) {
                LOG.debug((Object)("could not instantiate class " + providerClassName), (Throwable)e);
            }
            catch (IllegalStateException e) {
                LOG.debug((Object)("constructor of class " + providerClassName + " threw exception"), (Throwable)e);
            }
        }
        LOG.info((Object)"falling back to DefaultAuthenticationPovider");
        return new DefaultAuthenticationProvider();
    }

    @Override
    public Collection<Alias> getAliases() {
        return this.securityContext.getAliases();
    }

    @Override
    public Object getAliasValue(Alias alias) {
        return this.securityContext.getAliasValue(alias);
    }

    @Override
    public <T> Collection<T> getAliasValues(Alias alias) {
        return this.securityContext.getAliasValues(alias);
    }

    @Override
    public void setConfiguration(Configuration configuration) {
        this.securityContext.setConfiguration(configuration);
    }

    @Override
    public void setMappingInformation(MappingInformation persistenceMapping) {
        this.securityContext.setMappingInformation(persistenceMapping);
    }

    @Override
    public void setMappingProperties(Map<String, Object> properties) {
        this.securityContext.setMappingProperties(properties);
    }

    @Override
    public void setSecurityContext(SecurityContext newSecurityContext) {
        this.securityContext.setSecurityContext(newSecurityContext);
    }

    static {
        ArrayList<String> authenticationProviderClassNames = new ArrayList<String>();
        authenticationProviderClassNames.add("net.sf.jpasecurity.spring.authentication.SpringAuthenticationProvider");
        authenticationProviderClassNames.add("net.sf.jpasecurity.security.authentication.EjbAuthenticationProvider");
        authenticationProviderClassNames.add("net.sf.jpasecurity.jsf.authentication.JsfAuthenticationProvider");
        AUTHENTICATION_PROVIDER_CLASS_NAMES = Collections.unmodifiableList(authenticationProviderClassNames);
    }
}

