/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.mapping.bean;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Member;
import java.util.Collection;
import java.util.Map;
import net.sf.jpasecurity.CascadeType;
import net.sf.jpasecurity.ExceptionFactory;
import net.sf.jpasecurity.SecurityUnit;
import net.sf.jpasecurity.configuration.DefaultExceptionFactory;
import net.sf.jpasecurity.mapping.AbstractSecurityUnitParser;
import net.sf.jpasecurity.mapping.DefaultClassMappingInformation;
import net.sf.jpasecurity.mapping.DefaultPropertyAccessStrategyFactory;
import net.sf.jpasecurity.mapping.PropertyAccessStrategyFactory;
import net.sf.jpasecurity.util.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanSecurityUnitParser
extends AbstractSecurityUnitParser {
    public JavaBeanSecurityUnitParser(SecurityUnit securityUnit) {
        this(securityUnit, new DefaultPropertyAccessStrategyFactory(), new DefaultExceptionFactory());
    }

    public JavaBeanSecurityUnitParser(SecurityUnit securityUnit, PropertyAccessStrategyFactory propertyAccessStrategyFactory, ExceptionFactory exceptionFactory) {
        super(securityUnit, propertyAccessStrategyFactory, exceptionFactory);
    }

    protected BeanInfo getBeanInfo(Class<?> beanClass) {
        try {
            return Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException e) {
            return null;
        }
    }

    protected PropertyDescriptor getPropertyDescriptor(Member member) {
        String name = this.getName(member);
        for (PropertyDescriptor propertyDescriptor : this.getBeanInfo(member.getDeclaringClass()).getPropertyDescriptors()) {
            if (!name.equals(propertyDescriptor.getName())) continue;
            return propertyDescriptor;
        }
        return null;
    }

    @Override
    protected boolean usesFieldAccess(Class<?> mappedClass) {
        return false;
    }

    @Override
    protected boolean isMapped(Class<?> mappedClass) {
        return mappedClass != Object.class && this.getBeanInfo(mappedClass) != null;
    }

    @Override
    protected boolean isMapped(Member member) {
        return this.getPropertyDescriptor(member) != null;
    }

    @Override
    protected boolean isMetadataComplete(Class<?> entityClass) {
        return false;
    }

    @Override
    protected boolean excludeDefaultEntityListeners(Class<?> entityClass) {
        return false;
    }

    @Override
    protected boolean excludeSuperclassEntityListeners(Class<?> entityClass) {
        return false;
    }

    @Override
    protected void parseEntityListeners(DefaultClassMappingInformation classMapping) {
    }

    @Override
    protected void parseEntityLifecycleMethods(DefaultClassMappingInformation classMapping) {
    }

    @Override
    protected Class<?> getIdClass(Class<?> entityClass, boolean usesFieldAccess) {
        return null;
    }

    @Override
    protected boolean isEmbeddable(Class<?> type) {
        return false;
    }

    @Override
    protected boolean isIdProperty(Member property) {
        return false;
    }

    @Override
    protected boolean isVersionProperty(Member property) {
        return false;
    }

    @Override
    protected boolean isGeneratedValue(Member property) {
        return false;
    }

    @Override
    protected boolean isFetchTypePresent(Member property) {
        return false;
    }

    @Override
    protected CascadeType[] getCascadeTypes(Member property) {
        return new CascadeType[0];
    }

    @Override
    protected boolean isSingleValuedRelationshipProperty(Member property) {
        Class<?> type = this.getType(property);
        return !Types.isSimplePropertyType(type) && !this.isCollectionValuedRelationshipProperty(property);
    }

    @Override
    protected boolean isCollectionValuedRelationshipProperty(Member property) {
        Class<?> type = this.getType(property);
        return type.isArray() || Collection.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type);
    }
}

