/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.jpql.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.sf.jpasecurity.ExceptionFactory;
import net.sf.jpasecurity.jpql.compiler.PathEvaluator;
import net.sf.jpasecurity.mapping.ClassMappingInformation;
import net.sf.jpasecurity.mapping.MappingInformation;
import net.sf.jpasecurity.mapping.PropertyMappingInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedPathEvaluator
implements PathEvaluator {
    private MappingInformation mappingInformation;
    private ExceptionFactory exceptionFactory;

    public MappedPathEvaluator(MappingInformation mappingInformation, ExceptionFactory exceptionFactory) {
        this.mappingInformation = mappingInformation;
        this.exceptionFactory = exceptionFactory;
    }

    @Override
    public Object evaluate(Object root, String path) {
        if (root == null) {
            return null;
        }
        Set<Object> rootCollection = root instanceof Collection ? (Set<Object>)root : Collections.singleton(root);
        List result = this.evaluateAll(rootCollection, path);
        if (result.size() > 1) {
            throw this.exceptionFactory.createInvalidPathException(path, "path is not single-valued");
        }
        return result.isEmpty() ? null : result.iterator().next();
    }

    @Override
    public <R> List<R> evaluateAll(Collection<?> root, String path) {
        String[] pathElements = path.split("\\.");
        ArrayList rootCollection = new ArrayList(root);
        ArrayList<Object> resultCollection = new ArrayList<Object>();
        for (String property : pathElements) {
            resultCollection.clear();
            for (Object e : rootCollection) {
                ClassMappingInformation classMapping = this.mappingInformation.getClassMapping(e.getClass());
                if (!classMapping.containsPropertyMapping(property)) continue;
                PropertyMappingInformation propertyMapping = classMapping.getPropertyMapping(property);
                Object result = propertyMapping.getPropertyValue(e);
                if (result instanceof Collection) {
                    resultCollection.addAll((Collection)result);
                    continue;
                }
                if (result == null) continue;
                resultCollection.add(result);
            }
            rootCollection.clear();
            for (Object e : resultCollection) {
                if (e instanceof Collection) {
                    rootCollection.addAll((Collection)e);
                    continue;
                }
                rootCollection.add(e);
            }
        }
        return resultCollection;
    }
}

