/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.jpasecurity.AccessType;
import net.sf.jpasecurity.jpql.JpqlCompiledStatement;
import net.sf.jpasecurity.jpql.parser.JpqlAccessRule;
import net.sf.jpasecurity.jpql.parser.JpqlCollectionIdentifier;
import net.sf.jpasecurity.jpql.parser.JpqlCreate;
import net.sf.jpasecurity.jpql.parser.JpqlDelete;
import net.sf.jpasecurity.jpql.parser.JpqlIdentifier;
import net.sf.jpasecurity.jpql.parser.JpqlIn;
import net.sf.jpasecurity.jpql.parser.JpqlRead;
import net.sf.jpasecurity.jpql.parser.JpqlUpdate;
import net.sf.jpasecurity.jpql.parser.JpqlVisitorAdapter;
import net.sf.jpasecurity.mapping.Alias;
import net.sf.jpasecurity.mapping.MappingInformation;
import net.sf.jpasecurity.mapping.TypeDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessRule
extends JpqlCompiledStatement {
    public static final String DEFAULT_USER_PARAMETER_NAME = "user";
    public static final String DEFAULT_ROLE_PARAMETER_NAME = "roles";
    public static final String DEFAULT_ROLES_PARAMETER_NAME = "roles";
    private Set<AccessType> access;

    public AccessRule(JpqlAccessRule rule, TypeDefinition typeDefinition) {
        super(rule, Collections.singletonList(typeDefinition.getAlias().getName()), Collections.singleton(typeDefinition), Collections.<String>emptySet());
    }

    public String getSelectedPath() {
        return this.getSelectedPaths().get(0);
    }

    public Class<?> getSelectedType(MappingInformation mappingInformation) {
        return this.getSelectedTypes(mappingInformation).values().iterator().next();
    }

    public Collection<JpqlIdentifier> getIdentifierNodes(Alias alias) {
        ArrayList identifierNodes = new ArrayList();
        this.visit(new IdentifierVisitor(alias.getName()), identifierNodes);
        return Collections.unmodifiableCollection(identifierNodes);
    }

    public Collection<JpqlIn> getInNodes(Alias alias) {
        ArrayList inNodes = new ArrayList();
        this.visit(new CollectionIdentifierVisitor(alias.getName()), inNodes);
        return Collections.unmodifiableCollection(inNodes);
    }

    public boolean isAssignable(Class<?> type, MappingInformation mappingInformation) {
        return this.getSelectedType(mappingInformation).isAssignableFrom(type);
    }

    public boolean mayBeAssignable(Class<?> type, MappingInformation mappingInformation) {
        return type.isAssignableFrom(this.getSelectedType(mappingInformation));
    }

    public boolean grantsCreateAccess() {
        return this.getAccess().contains((Object)AccessType.CREATE);
    }

    public boolean grantsReadAccess() {
        return this.getAccess().contains((Object)AccessType.READ);
    }

    public boolean grantsUpdateAccess() {
        return this.getAccess().contains((Object)AccessType.UPDATE);
    }

    public boolean grantsDeleteAccess() {
        return this.getAccess().contains((Object)AccessType.DELETE);
    }

    public boolean grantsAccess(AccessType type) {
        return this.getAccess().contains((Object)type);
    }

    @Override
    public AccessRule clone() {
        return (AccessRule)super.clone();
    }

    private Set<AccessType> getAccess() {
        if (this.access == null) {
            HashSet<AccessType> access = new HashSet<AccessType>();
            AccessVisitor visitor = new AccessVisitor();
            this.visit(visitor, access);
            if (access.size() == 0) {
                access.addAll(Arrays.asList(AccessType.values()));
            }
            this.access = Collections.unmodifiableSet(access);
        }
        return this.access;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CollectionIdentifierVisitor
    extends JpqlVisitorAdapter<List<JpqlIn>> {
        private String identifier;

        public CollectionIdentifierVisitor(String identifier) {
            if (identifier == null) {
                throw new IllegalArgumentException("identifier may not be null");
            }
            this.identifier = identifier.toLowerCase();
        }

        @Override
        public boolean visit(JpqlCollectionIdentifier node, List<JpqlIn> inRoles) {
            if (this.identifier.equals(node.getValue().toLowerCase())) {
                inRoles.add((JpqlIn)node.jjtGetParent());
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IdentifierVisitor
    extends JpqlVisitorAdapter<List<JpqlIdentifier>> {
        private String identifier;

        public IdentifierVisitor(String identifier) {
            if (identifier == null) {
                throw new IllegalArgumentException("identifier may not be null");
            }
            this.identifier = identifier.toLowerCase();
        }

        @Override
        public boolean visit(JpqlIdentifier node, List<JpqlIdentifier> inRoles) {
            if (this.identifier.equals(node.getValue().toLowerCase())) {
                inRoles.add(node);
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AccessVisitor
    extends JpqlVisitorAdapter<Collection<AccessType>> {
        private AccessVisitor() {
        }

        @Override
        public boolean visit(JpqlCreate node, Collection<AccessType> access) {
            access.add(AccessType.CREATE);
            return true;
        }

        @Override
        public boolean visit(JpqlRead node, Collection<AccessType> access) {
            access.add(AccessType.READ);
            return true;
        }

        @Override
        public boolean visit(JpqlUpdate node, Collection<AccessType> access) {
            access.add(AccessType.UPDATE);
            return true;
        }

        @Override
        public boolean visit(JpqlDelete node, Collection<AccessType> access) {
            access.add(AccessType.DELETE);
            return true;
        }
    }
}

