#!/bin/sh

# Copyright (C) since 2006 NTT DATA Corporation
# 
# This program is free software; you can redistribute it and/or
# Modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation, version 2.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details

# bash configuration
SU_PROC="/bin/su"
MKDIR_PROC="/bin/mkdir"
TOUCH_PROC="/bin/touch"
CHMOD_PROC="/bin/chmod"
LS_PROC="/bin/ls"
GREP_PROC="/bin/grep"
EXPECT_PROC="/usr/bin/expect"
SSH_PROC="/usr/bin/ssh"
SSHKEYGEN_PROC="/usr/bin/ssh-keygen -t rsa"

AGENT_HOME="/opt/hinemos_agent"
AGENT_PROPERTIES="${AGENT_HOME}/conf/Agent.properties"

# Variables
ip_address=""
root_pass=""
user=""
pass=""

##
## Argument setting
##
while [ $# -gt 0 ] 
do
  case $1 in
    -i)
      shift
      ip_address=$1
      ;;
    -r)
      shift
      root_pass=$1
      ;;
    -u)
      shift
      user=$1
      user_home=`${GREP_PROC} ^${user}: /etc/passwd | awk -F: '{print $6}'`
      ;;
    -p)
      shift
      pass=$1 
      ;;
    *)
      ;;
  esac

  shift 

done


##
## Confirmation
##

# Input value
if [ "${ip_address}" = "" ]; then
    echo "Please input forwarding former IP address."
    exit 1
elif [ "${root_pass}" = "" ]; then
    echo "Please input forwarding former root user's password."
    exit 1
elif [ "${user}" = "" ]; then
    echo "Please input the file transfer execution user-name."
    exit 1
elif [ "${pass}" = "" ]; then
    echo "Please input file transfer execution user's password."
    exit 1
fi

## Forwarding site
# The forwarding user's confirmation (forwarding site)
if [ "`cat /etc/passwd | ${GREP_PROC} ^${user}:`" = "" ]; then
    echo "${user} doesn't exist."
    exit 1
fi

# The Hinemos agent's confirmation
if [ ! -f ${AGENT_PROPERTIES} ]; then
    echo "The Hinemos agent is not installed in ${HOSTNAME}."
    exit 1 
fi


## Forwarding origin
# Confirmation of IP address and confirmation of password
$EXPECT_PROC -c "
    set timeout 1
    spawn -noecho $SSH_PROC -n ${ip_address} -l root
    expect {
        -re \".*Name or service not known\" { exit 1}
        \"Are you sure\" { send yes\r }
        timeout
    }
    expect root
    send ${root_pass}\r
    expect {
        -re \".*root\" { exit 0 }
        timeout { exit 2 }
    }
" > /dev/null
case $? in
    1)
      echo "IP:${ip_address} IP address doesn't exist. "
      exit 1
      ;;
    2)
      echo "IP:${ip_address} Root user's password is wrong."
      exit 1
      ;;
    *)
      break
      ;;
esac

# Confirmation of forwarding user and the agent's confirmation
$EXPECT_PROC -c "
    set timeout 1
    spawn -noecho $SSH_PROC -n ${ip_address} -l ${user} \"
        ${LS_PROC} ${AGENT_PROPERTIES}
    \"
    expect ${user}    
    send ${pass}\r
    expect {
        -re \".*${AGENT_PROPERTIES}\" { exit 0 }
        -re \".*${LS_PROC}\" { exit 2 }
        timeout { exit 1 }
    }
" > /dev/null
case $? in
    1)
      echo "IP:${ip_address} ${user} doesn't exist or the password of ${user} is wrong." 
      exit 1
      ;;
    2)
      echo "IP:${ip_address} The Hinemos agent is not installed."
      exit 1
      ;;
    *)
      break
      ;;
esac




##
## Setting of forwarding site
##

# Forwarding user's public key is made.
$SU_PROC - $user -c "
    if [ ! -f ${user_home}/.ssh/id_rsa.pub ]; then
        $EXPECT_PROC -c \"
            spawn -noecho ${SSHKEYGEN_PROC}
            expect Enter
            send \r
            expect Enter
            send \r 
            expect Enter
            send \r
            expect eof
        \"
    fi
"  > /dev/null


# Forwarding user's public key is registered to the Hinemos agent.
if [ -f ${AGENT_PROPERTIES} ]; then

    TMP_KEY="${user}.public.key=`cat ${user_home}/.ssh/id_rsa.pub`"
    if [ `${GREP_PROC} "${TMP_KEY}" ${AGENT_PROPERTIES} | wc -l` = 0 ]; then 
        echo -n $TMP_KEY >> ${AGENT_PROPERTIES}
    fi

else # When the Hinemos agent is not installed.
    echo "The Hinemos agent is not installed."
    exit 1
fi 


# The host key to the forwarding site is registered in forwarding user's known_hosts.
$SU_PROC - $user -c "
    $EXPECT_PROC -c \"
        set timeout 1
        spawn $SSH_PROC -n ${ip_address} -l ${user}
        expect {
            \\\"Are you sure\\\" { send yes\r }
            timeout
        }
        expect eof
    \"
"  > /dev/null




##
## Setting of forwarding origin
##

# The authorized_keys file is made for the forwarding user. 
$EXPECT_PROC -c "
    set timeout 1
    spawn $SSH_PROC -n ${ip_address} -l ${user} \"
        ${MKDIR_PROC} -m 700 ${user_home}/.ssh
        ${TOUCH_PROC} ${user_home}/.ssh/authorized_keys
        ${CHMOD_PROC} 600 ${user_home}/.ssh/authorized_keys 
    \"
    expect ${user}
    send ${pass}\r
    expect eof
" > /dev/null


# Path forwarding user's authorized_keys is registered in Agent.properties in the forwarding origin. 
$EXPECT_PROC -c "
    set timeout 1
    spawn -noecho $SSH_PROC -n ${ip_address} -l root \"
        if \[ \`${GREP_PROC} ${user}.authorized.keys.path=${user_home}/.ssh/authorized_keys ${AGENT_PROPERTIES} | wc -l\` = 0 \]; then
            echo -n ${user}.authorized.keys.path=${user_home}/.ssh/authorized_keys >> ${AGENT_PROPERTIES}
        fi        
    \"
    expect root
    send ${root_pass}\r
    expect eof
" > /dev/null

echo "The setting ended normally."
exit
