/*

 Copyright (C) 2012 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.snmptrap.bean;

import java.io.Serializable;
import java.util.List;

public class SnmpTrapV1 implements Serializable {

	private static final long serialVersionUID = 1L;

	public long receivedTime;
	public String community;

	public String agentAddr;
	public String enterpriseId;
	public int genericId;
	public int specificId;
	public long sysUptime;

	private List<SnmpVarbind> varbinds;

	public SnmpTrapV1() {

	}

	public SnmpTrapV1(long receivedTime, String community, String agentAddr,
			String enterpriseId, int genericId, int specificId,
			long sysUptime, List<SnmpVarbind> varbinds) {
		this.receivedTime = receivedTime;
		this.community = community;
		this.agentAddr = agentAddr;
		this.enterpriseId = enterpriseId;
		this.genericId = genericId;
		this.specificId = specificId;
		this.sysUptime = sysUptime;
		this.varbinds = varbinds;
	}

	public List<SnmpVarbind> getVarbinds() {
		return varbinds;
	}

	public void setVarbinds(List<SnmpVarbind> varbinds){
		this.varbinds = varbinds;
	}

	@Override
	public boolean equals(Object obj) {
		if (obj instanceof SnmpTrapV1) {
			if (obj == this) {
				return true;
			}

			SnmpTrapV1 st = (SnmpTrapV1)obj;
			if (community == null || st.community == null
					|| agentAddr == null || st.agentAddr == null
					|| enterpriseId == null || st.enterpriseId == null) {
				return false;
			}

			if (receivedTime == st.receivedTime && community.equals(st.community)
					&& agentAddr.equals(st.agentAddr)
					&& enterpriseId.equals(st.enterpriseId)
					&& genericId == st.genericId && specificId == st.specificId) {
				return true;
			}
		}

		return false;
	}

	@Override
	public int hashCode() {
		int h = 1;

		h = h * 31 + (int)receivedTime;
		h = h * 31 + (community == null ? 0 : community.hashCode());
		h = h * 31 + (agentAddr == null ? 0 : agentAddr.hashCode());
		h = h * 31 + (enterpriseId == null ? 0 : enterpriseId.hashCode());
		h = h * 31 + genericId;
		h = h * 31 + specificId;
		h = h * 31 + (int)sysUptime;

		return h;
	}

	@Override
	public String toString() {
		return String.format("%s [receivedTime = %s, community = %s, agentAddr = %s, "
				+ "enterpriseId = %s, genericId = %s, specificId = %s, sysUptime = %s]"
				, this.getClass().getSimpleName(), receivedTime, community, agentAddr,
				enterpriseId, genericId, specificId, sysUptime);
	}

}
