/*

Copyright (C) 2011 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.repository.util;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.repository.bean.NodeInfo;
import com.clustercontrol.repository.bean.NodeVariableInfo;

/**
 * リポジトリに関するUtilityクラス<br/>
 * 
 * @author takahatat
 *
 */
public class RepositoryUtil {

	private static Log log = LogFactory.getLog(RepositoryUtil.class);

	public static final String _KEY_FACILITY_ID = "FACILITY_ID";
	public static final String _KEY_FACILITY_NAME = "FACILITY_NAME";

	public static final String _KEY_IP_ADDRESS_VERSION = "IP_ADDRESS_VERSION";
	public static final String _KEY_IP_ADDRESS = "IP_ADDRESS";
	public static final String _KEY_IP_ADDRESS_V4 = "IP_ADDRESS_V4";
	public static final String _KEY_IP_ADDRESS_V6 = "IP_ADDRESS_V6";

	public static final String _KEY_NODE_NAME = "NODE_NAME";
	public static final String _KEY_OS_NAME = "OS_NAME";
	public static final String _KEY_OS_RELEASE = "OS_RELEASE";
	public static final String _KEY_OS_VERSION = "OS_VERSION";
	public static final String _KEY_CHARSET = "CHARSET";

	public static final String _KEY_AGENT_AWAKE_PORT = "AGENT_AWAKE_PORT";

	public static final String _JOB_PRIORITY = "JOB_PRIORITY";
	public static final String _JOB_MULTIPLICITY = "JOB_MULTIPLICITY";

	public static final String _KEY_SNMP_PORT = "SNMP_PORT";
	public static final String _KEY_SNMP_COMMUNITY = "SNMP_COMMUNITY";
	public static final String _KEY_SNMP_VERSION = "SNMP_VERSION";
	public static final String _KEY_SNMP_TIMEOUT = "SNMP_TIMEOUT";
	public static final String _KEY_SNMP_TRIES = "SNMP_TRIES";

	public static final String _KEY_WBEM_PORT = "WBEM_PORT";
	public static final String _KEY_WBEM_PROTOCOL = "WBEM_PROTOCOL";
	public static final String _KEY_WBEM_TIMEOUT = "WBEM_TIMEOUT";
	public static final String _KEY_WBEM_TRIES = "WBEM_TRIES";
	public static final String _KEY_WBEM_USER = "WBEM_USER";
	public static final String _KEY_WBEM_PASSWORD = "WBEM_PASSWORD";

	public static final String _KEY_WINRM_USER = "WINRM_USER";
	public static final String _KEY_WINRM_PASSWORD = "WINRM_PASSWORD";
	public static final String _KEY_WINRM_VERSION = "WINRM_VERSION";
	public static final String _KEY_WINRM_PORT = "WINRM_PORT";
	public static final String _KEY_WINRM_PROTOCOL = "WINRM_PROTOCOL";
	public static final String _KEY_WINRM_TIMEOUT = "WINRM_TIMEOUT";
	public static final String _KEY_WINRM_TRIES = "WINRM_TRIES";

	public static final String _KEY_IPMI_IP_ADDRESS = "IPMI_IP_ADDRESS";
	public static final String _KEY_IPMI_PORT = "IPMI_PORT";
	public static final String _KEY_IPMI_TIMEOUT = "IPMI_TIMEOUT";
	public static final String _KEY_IPMI_TRIES = "IPMI_TRIES";
	public static final String _KEY_IPMI_PROTOCOL = "IPMI_PROTOCOL";
	public static final String _KEY_IPMI_LEVEL = "IPMI_LEVEL";
	public static final String _KEY_IPMI_USER = "IPMI_USER";
	public static final String _KEY_IPMI_PASSWORD = "IPMI_PASSWORD";

	public static final String _KEY_VM_NODE_TYPE = "VM_NODE_TYPE";
	public static final String _KEY_VM_NAME = "VM_NAME";
	public static final String _KEY_VM_ID = "VM_ID";
	public static final String _KEY_VM_USER = "VM_USER";
	public static final String _KEY_VM_PASSWORD = "VM_PASSWORD";
	public static final String _KEY_VM_PROTOCOL = "VM_PROTOCOL";

	public static final String _KEY_CLOUD_NODE_TYPE = "CLOUD_NODE_TYPE";
	public static final String _KEY_CLOUD_SERVICE = "CLOUD_SERVICE";
	public static final String _KEY_CLOUD_ACCOUNT_RESOURCE = "CLOUD_ACCOUNT_RESOURCE";
	public static final String _KEY_CLOUD_RESOURCE_TYPE = "CLOUD_RESOURCE_TYPE";
	public static final String _KEY_CLOUD_RESOURCE_ID = "CLOUD_RESOURCE_TYPEID";
	public static final String _KEY_CLOUD_REGION = "CLOUD_REGION";
	public static final String _KEY_CLOUD_ZONE = "CLOUD_ZONE";

	public static final String _KEY_VSWITCH_TYPE = "VSWITCH_TYPE";
	public static final String _KEY_OPENFLOW_DATA_PATHID = "OF_DATAPATHID";
	public static final String _KEY_OPENFLOW_CTRL_IP_ADDRESS = "OF_CTRL_IP_ADDRESS";

	/**
	 * ノードの基本情報をハッシュとして返す
	 * @param nodeInfo
	 * @return
	 */
	public static Map<String, String> createNodeParameter(NodeInfo nodeInfo) {
		Map<String, String> param = null;

		if (nodeInfo != null) {
			param = new HashMap<String, String>();

			param.put(_KEY_FACILITY_ID, nodeInfo.getFacilityId());
			param.put(_KEY_FACILITY_NAME, nodeInfo.getFacilityName());

			param.put(_KEY_IP_ADDRESS_VERSION, nodeInfo.getIpAddressVersion() == null ? null : nodeInfo.getIpAddressVersion().toString());
			param.put(_KEY_IP_ADDRESS, nodeInfo.getIpAddressVersion() == 4 ? nodeInfo.getIpAddressV4() : nodeInfo.getIpAddressV6());
			param.put(_KEY_IP_ADDRESS_V4, nodeInfo.getIpAddressV4());
			param.put(_KEY_IP_ADDRESS_V6, nodeInfo.getIpAddressV6());

			param.put(_KEY_NODE_NAME, nodeInfo.getNodeName());
			param.put(_KEY_OS_NAME, nodeInfo.getOsName());
			param.put(_KEY_OS_RELEASE, nodeInfo.getOsRelease());
			param.put(_KEY_OS_VERSION, nodeInfo.getOsVersion());
			param.put(_KEY_CHARSET, nodeInfo.getCharacterSet());

			param.put(_KEY_AGENT_AWAKE_PORT, nodeInfo.getAgentAwakePort() == null ? null : nodeInfo.getAgentAwakePort().toString());

			param.put(_JOB_PRIORITY, nodeInfo.getJobPriority() == null ? null : nodeInfo.getJobPriority().toString());
			param.put(_JOB_MULTIPLICITY, nodeInfo.getJobMultiplicity() == null ? null : nodeInfo.getJobMultiplicity().toString());

			param.put(_KEY_SNMP_PORT, nodeInfo.getSnmpPort() == null ? null : nodeInfo.getSnmpPort().toString());
			param.put(_KEY_SNMP_COMMUNITY, nodeInfo.getSnmpCommunity());
			param.put(_KEY_SNMP_VERSION, nodeInfo.getSnmpVersion());
			param.put(_KEY_SNMP_TIMEOUT, nodeInfo.getSnmpTimeout() == null ? null : nodeInfo.getSnmpTimeout().toString());
			param.put(_KEY_SNMP_TRIES, nodeInfo.getSnmpRetryCount() == null ? null : nodeInfo.getSnmpRetryCount().toString());

			param.put(_KEY_WBEM_PORT, nodeInfo.getWbemPort() == null ? null : nodeInfo.getWbemPort().toString());
			param.put(_KEY_WBEM_PROTOCOL, nodeInfo.getWbemProtocol());
			param.put(_KEY_WBEM_TIMEOUT, nodeInfo.getWbemTimeout() == null ? null : nodeInfo.getWbemTimeout().toString());
			param.put(_KEY_WBEM_TRIES, nodeInfo.getWbemRetryCount() == null ? null : nodeInfo.getWbemRetryCount().toString());
			param.put(_KEY_WBEM_USER, nodeInfo.getWbemUser());
			param.put(_KEY_WBEM_PASSWORD, nodeInfo.getWbemUserPassword());

			param.put(_KEY_WINRM_USER, nodeInfo.getWinrmUser());
			param.put(_KEY_WINRM_PASSWORD, nodeInfo.getWinrmUserPassword());
			param.put(_KEY_WINRM_VERSION, nodeInfo.getWinrmVersion());
			param.put(_KEY_WINRM_PORT, nodeInfo.getWinrmPort() == null ? null : nodeInfo.getWinrmPort().toString());
			param.put(_KEY_WINRM_PROTOCOL, nodeInfo.getWinrmProtocol());
			param.put(_KEY_WINRM_TIMEOUT, nodeInfo.getWinrmTimeout() == null ? null : nodeInfo.getWinrmTimeout().toString());
			param.put(_KEY_WINRM_TRIES, nodeInfo.getWinrmRetries() == null ? null : nodeInfo.getWinrmRetries().toString());

			param.put(_KEY_IPMI_IP_ADDRESS, nodeInfo.getIpmiIpAddress());
			param.put(_KEY_IPMI_PORT, nodeInfo.getIpmiPort() == null ? null : nodeInfo.getIpmiPort().toString());
			param.put(_KEY_IPMI_TIMEOUT, nodeInfo.getIpmiTimeout() == null ? null : nodeInfo.getIpmiTimeout().toString());
			param.put(_KEY_IPMI_TRIES, nodeInfo.getIpmiRetries() == null ? null : nodeInfo.getIpmiRetries().toString());
			param.put(_KEY_IPMI_PROTOCOL, nodeInfo.getIpmiProtocol());
			param.put(_KEY_IPMI_LEVEL, nodeInfo.getIpmiLevel());
			param.put(_KEY_IPMI_USER, nodeInfo.getIpmiUser());
			param.put(_KEY_IPMI_PASSWORD, nodeInfo.getIpmiUserPassword());

			param.put(_KEY_VM_NODE_TYPE, nodeInfo.getVmNodeType());
			param.put(_KEY_VM_NAME, nodeInfo.getVmName());
			param.put(_KEY_VM_ID, nodeInfo.getVmId());
			param.put(_KEY_VM_USER, nodeInfo.getVmUser());
			param.put(_KEY_VM_PASSWORD, nodeInfo.getVmUserPassword());
			param.put(_KEY_VM_PROTOCOL, nodeInfo.getVmProtocol());

			param.put(_KEY_VSWITCH_TYPE, nodeInfo.getvNetSwitchType());
			param.put(_KEY_OPENFLOW_DATA_PATHID, nodeInfo.getOpenFlowDataPathId());
			param.put(_KEY_OPENFLOW_CTRL_IP_ADDRESS, nodeInfo.getOpenFlowCtrlIpAddress());

			param.put(_KEY_CLOUD_NODE_TYPE, nodeInfo.getCloudNodeType());
			param.put(_KEY_CLOUD_SERVICE, nodeInfo.getCloudService());
			param.put(_KEY_CLOUD_ACCOUNT_RESOURCE, nodeInfo.getCloudAccountResouce());
			param.put(_KEY_CLOUD_RESOURCE_TYPE, nodeInfo.getCloudResourceType());
			param.put(_KEY_CLOUD_RESOURCE_ID, nodeInfo.getCloudResourceId());
			param.put(_KEY_CLOUD_REGION, nodeInfo.getCloudRegion());
			param.put(_KEY_CLOUD_ZONE, nodeInfo.getCloudZone());

			if (nodeInfo.getNodeVariableInfo() != null) {
				for (NodeVariableInfo info : nodeInfo.getNodeVariableInfo()) {
					if (info.getNodeVariableName() == null || "".equals(info.getNodeVariableName())) {
						if (log.isDebugEnabled()) log.debug("key is not valid. (key = " + info.getNodeVariableName() + ")");
						continue;
					}
					if (param.containsKey(info.getNodeVariableName())) {
						log.info("duplicated key (key = " + info.getNodeVariableName() + "). this parameter will be used. (value = " + param.get(info.getNodeVariableName()) + ")");
						continue;
					}
					if (log.isTraceEnabled()) log.trace("adding user parameter. (key = " + info.getNodeVariableName() + ", value = " + info.getNodeVariableValue() + ")");
					param.put(info.getNodeVariableName(), info.getNodeVariableValue());
				}
			}
		}

		return param;
	}

}
