package com.clustercontrol.monitor.run.factory;

import java.util.ArrayList;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.fault.InvalidRole;
import com.clustercontrol.fault.MonitorNotFound;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.monitor.run.bean.MonitorTrapValueInfo;
import com.clustercontrol.monitor.run.model.MonitorInfoEntity;
import com.clustercontrol.monitor.run.model.MonitorTrapValueInfoEntity;
import com.clustercontrol.monitor.run.util.QueryUtil;

/**
 * SNMPTRAP監視の判定情報を作成する抽象クラス<BR>
 * <p>
 * SNMPTRAP監視を行う各監視管理クラスで継承してください。
 *
 * @version 4.0.0
 * @since 4.0.0
 */
public abstract class AddMonitorTrapValueType extends AddMonitor {

	/** ログ出力のインスタンス。 */
	private static Log m_log = LogFactory.getLog( AddMonitorTrapValueType.class );

	@Override
	protected boolean addJudgementInfo() throws MonitorNotFound, InvalidRole {
		m_log.debug("addJudgementInfo() : start");
		MonitorInfoEntity monitorEntity = QueryUtil.getMonitorInfoPK(m_monitorInfo.getMonitorId());

		ArrayList<MonitorTrapValueInfo> valueList = m_monitorInfo.getTrapValueInfo();

		// SNMPTRAP監視判定情報を設定
		if(valueList == null){
			m_log.debug("addJudgementInfo() : MonitorId = " + m_monitorInfo.getMonitorId() + ", MonitorTrapValueInfo List is null");
			return true;
		}

		MonitorTrapValueInfo value = null;
		for(int index=0; index<valueList.size(); index++){
			value = valueList.get(index);
			if(value != null){
				MonitorTrapValueInfoEntity entity = new MonitorTrapValueInfoEntity(
						monitorEntity,
						value.getMib(),
						value.getTrapOid(),
						value.getGenericId(),
						value.getSpecificId(),
						value.getUei());
				entity.setDescr(value.getDescr());
				entity.setLogmsg(value.getLogmsg());
				entity.setPriority(value.getPriority());
				entity.setValidFlg(ValidConstant.booleanToType(value.isValidFlg()));

				// for debug
				m_log.debug("addJudgementInfo() : MonitorId = " + m_monitorInfo.getMonitorId() +
						",Mib = " + value.getMib() +
						",TrapOid = " + value.getTrapOid() +
						",GenericId = " + value.getGenericId() +
						",SpecificId = " + value.getSpecificId() +
						",Uei = " + value.getUei() +
						",ValidFlg = " + value.isValidFlg() +
						",Priority = " + value.getPriority() +
						",Logmsg = " + value.getLogmsg() +
						",Descr = " + value.getDescr());

			}
		}
		m_log.debug("addJudgementInfo() : end");
		return true;
	}
}
