package com.clustercontrol.jobmanagement.model;

import java.io.Serializable;
import javax.persistence.*;

import com.clustercontrol.commons.util.JpaTransactionManager;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;


/**
 * The persistent class for the cc_job_session_node database table.
 * 
 */
@Entity
@Table(name="cc_job_session_node")
public class JobSessionNodeEntity implements Serializable {
	private static final long serialVersionUID = 1L;
	private JobSessionNodeEntityPK id;
	private String nodeName				=	null;
	private Integer status				=	null;
	private Timestamp startDate			=	null;
	private Timestamp endDate			=	null;
	private Integer endValue			=	null;
	private String message				=	null;
	private Integer retryCount			=	0;
	private String result				=	null;
	private JobSessionJobEntity jobSessionJobEntity;

	@Deprecated
	public JobSessionNodeEntity() {
	}

	public JobSessionNodeEntity(JobSessionNodeEntityPK pk,
			JobSessionJobEntity jobSessionJobEntity) {
		this.setId(pk);
		EntityManager em = new JpaTransactionManager().getEntityManager();
		em.persist(this);
		this.relateToJobSessionJobEntity(jobSessionJobEntity);
	}

	public JobSessionNodeEntity(JobSessionJobEntity jobSessionJobEntity, String facilityId) {
		this(new JobSessionNodeEntityPK(
				jobSessionJobEntity.getId().getSessionId(),
				jobSessionJobEntity.getId().getJobunitId(),
				jobSessionJobEntity.getId().getJobId(),
				facilityId), jobSessionJobEntity);
	}


	@EmbeddedId
	public JobSessionNodeEntityPK getId() {
		return this.id;
	}

	public void setId(JobSessionNodeEntityPK id) {
		this.id = id;
	}

	@Column(name="end_date")
	public Timestamp getEndDate() {
		return this.endDate;
	}

	public void setEndDate(Timestamp endDate) {
		this.endDate = endDate;
	}


	@Column(name="end_value")
	public Integer getEndValue() {
		return this.endValue;
	}

	public void setEndValue(Integer endValue) {
		this.endValue = endValue;
	}


	public String getMessage() {
		return this.message;
	}

	public void setMessage(String message) {
		this.message = message;
	}


	@Column(name="node_name")
	public String getNodeName() {
		return this.nodeName;
	}

	public void setNodeName(String nodeName) {
		this.nodeName = nodeName;
	}


	public String getResult() {
		return this.result;
	}

	public void setResult(String result) {
		this.result = result;
	}


	@Column(name="retry_count")
	public Integer getRetryCount() {
		return this.retryCount;
	}

	public void setRetryCount(Integer retryCount) {
		this.retryCount = retryCount;
	}


	@Column(name="start_date")
	public Timestamp getStartDate() {
		return this.startDate;
	}

	public void setStartDate(Timestamp startDate) {
		this.startDate = startDate;
	}


	public Integer getStatus() {
		return this.status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	//bi-directional many-to-one association to JobSessionJobEntity
	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumns({
		@JoinColumn(name="job_id", referencedColumnName="job_id", insertable=false, updatable=false),
		@JoinColumn(name="jobunit_id", referencedColumnName="jobunit_id", insertable=false, updatable=false),
		@JoinColumn(name="session_id", referencedColumnName="session_id", insertable=false, updatable=false)
	})
	public JobSessionJobEntity getJobSessionJobEntity() {
		return this.jobSessionJobEntity;
	}

	@Deprecated
	public void setJobSessionJobEntity(JobSessionJobEntity jobSessionJobEntity) {
		this.jobSessionJobEntity = jobSessionJobEntity;
	}

	/**
	 * JobSessionJobEntityオブジェクト参照設定<BR>
	 * 
	 * JobSessionJobEntity設定時はSetterに代わりこちらを使用すること。
	 * 
	 * JPAの仕様(JSR 220)では、データ更新に伴うrelationshipの管理はユーザに委ねられており、
	 * INSERTやDELETE時に、そのオブジェクトに対する参照をメンテナンスする処理を実装する。
	 * 
	 * JSR 220 3.2.3 Synchronization to the Database
	 * 
	 * Bidirectional relationships between managed entities will be persisted
	 * based on references held by the owning side of the relationship.
	 * It is the developer’s responsibility to keep the in-memory references
	 * held on the owning side and those held on the inverse side consistent
	 * with each other when they change.
	 */
	public void relateToJobSessionJobEntity(JobSessionJobEntity jobSessionJobEntity) {
		this.setJobSessionJobEntity(jobSessionJobEntity);
		if (jobSessionJobEntity != null) {
			List<JobSessionNodeEntity> list = jobSessionJobEntity.getJobSessionNodeEntities();
			if(list == null) {
				list = new ArrayList<JobSessionNodeEntity>();
			} else {
				for(JobSessionNodeEntity entity : list) {
					if (entity.getId().equals(this.getId())) {
						return;
					}
				}
			}
			list.add(this);
			jobSessionJobEntity.setJobSessionNodeEntities(list);
		}
	}

	/**
	 * 削除前処理<BR>
	 * 
	 * JPAの仕様(JSR 220)では、データ更新に伴うrelationshipの管理はユーザに委ねられており、
	 * INSERTやDELETE時に、そのオブジェクトに対する参照をメンテナンスする処理を実装する。
	 * 
	 * JSR 220 3.2.3 Synchronization to the Database
	 * 
	 * Bidirectional relationships between managed entities will be persisted
	 * based on references held by the owning side of the relationship.
	 * It is the developer’s responsibility to keep the in-memory references
	 * held on the owning side and those held on the inverse side consistent
	 * with each other when they change.
	 */
	public void unchain() {

		// JobSessionJobEntity
		if (this.jobSessionJobEntity != null) {
			List<JobSessionNodeEntity> list = this.jobSessionJobEntity.getJobSessionNodeEntities();
			if (list != null) {
				Iterator<JobSessionNodeEntity> iter = list.iterator();
				while(iter.hasNext()) {
					JobSessionNodeEntity entity = iter.next();
					if (entity.getId().equals(this.getId())){
						iter.remove();
						break;
					}
				}
			}
		}
	}

}