/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GroupByClause
extends AbstractExpression {
    private AbstractExpression groupByItems;
    private boolean hasSpace;
    private String identifier;

    public GroupByClause(AbstractExpression parent) {
        super(parent, "GROUP BY");
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getGroupByItems().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getGroupByItems());
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        children.add(this.buildStringExpression(this.getText()));
        if (this.hasSpace) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.groupByItems != null) {
            children.add(this.groupByItems);
        }
    }

    public CollectionExpression buildCollectionExpression() {
        ArrayList<AbstractExpression> children = new ArrayList<AbstractExpression>(1);
        children.add((AbstractExpression)this.getGroupByItems());
        ArrayList<Boolean> commas = new ArrayList<Boolean>(1);
        commas.add(Boolean.FALSE);
        ArrayList<Boolean> spaces = new ArrayList<Boolean>(1);
        spaces.add(Boolean.FALSE);
        return new CollectionExpression(this, children, commas, spaces, true);
    }

    @Override
    public JPQLQueryBNF findQueryBNF(Expression expression) {
        if (this.groupByItems != null && this.groupByItems.isAncestor(expression)) {
            return this.getQueryBNF("groupby_item");
        }
        return super.findQueryBNF(expression);
    }

    public String getActualIdentifier() {
        return this.identifier;
    }

    public Expression getGroupByItems() {
        if (this.groupByItems == null) {
            this.groupByItems = this.buildNullExpression();
        }
        return this.groupByItems;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("groupby_clause");
    }

    public boolean hasGroupByItems() {
        return this.groupByItems != null && !this.groupByItems.isNull();
    }

    public boolean hasSpaceAfterGroupBy() {
        return this.hasSpace;
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        this.identifier = wordParser.moveForward("GROUP BY");
        this.hasSpace = wordParser.skipLeadingWhitespace() > 0;
        this.groupByItems = this.parse(wordParser, "groupby_item", tolerant);
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        writer.append(actual ? this.identifier : this.getText());
        if (this.hasSpace) {
            writer.append(' ');
        }
        if (this.groupByItems != null) {
            this.groupByItems.toParsedText(writer, actual);
        }
    }
}

