/*

Copyright (C) 2012 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class HinemosManagerCli {

	public static final int DEFAULT_CONNECT_TIMEOUT = 10;
	public static final int DEFAULT_REQUEST_TIMEOUT = 60;

	private static String url = null;
	private static String user = null;
	private static String password = null;

	private static int connectTimeout = DEFAULT_CONNECT_TIMEOUT;
	private static int requestTimeout = DEFAULT_REQUEST_TIMEOUT;

	private static class InvokeInfo {
		private final String className;
		private final String methodName;
		private final String[] args;

		public InvokeInfo(String className, String methodName, String[] args) {
			this.className = className;
			this.methodName = methodName;
			this.args = args;
		}
	}

	public static void main(String args[]) {
		InvokeInfo info = parse(args);
		String ret = null;
		try {
			EndpointManager.init(user, password, url, connectTimeout, requestTimeout);
			ret = ManagerCliEndpointWrapper.invoke(info.className, info.methodName, info.args);
		} catch (Exception e) {
			e.printStackTrace();
		}
		System.out.println(ret);

		System.exit(0);
	}

	private static InvokeInfo parse(String args[]) {
		Options options = new Options();

		options.addOption("url", true, "Hinemos Manager's URL (ex. http://127.0.0.1:8080/HinemosWS/)");
		options.addOption("u", true, "Login User Name");
		options.addOption("p", true, "Login Password");
		options.addOption("cto", true, "Connection Timeout [sec]");
		options.addOption("rto", true, "Request Timeout [sec]");
		options.addOption("c", true, "Static Class Name");
		options.addOption("m", true, "Static Method Name");

		CommandLineParser parser = new GnuParser();
		CommandLine cl = null;
		try {
			cl = parser.parse(options, args, true);
		} catch (ParseException e) {
			HelpFormatter hFormatter = new HelpFormatter();
			hFormatter.printHelp(String.format("java %s [opts] [args]", HinemosManagerCli.class.getName()), options);
			System.exit(1);
		}

		url = cl.getOptionValue("url", "http://127.0.0.1:8080/HinemosWS/");
		user = cl.getOptionValue("u", "HINEMOS_CLI");
		password = cl.getOptionValue("p", "HINEMOS_CLI");
		connectTimeout = Integer.parseInt(cl.getOptionValue("cto", new Integer(DEFAULT_CONNECT_TIMEOUT).toString()));
		requestTimeout = Integer.parseInt(cl.getOptionValue("rto", new Integer(DEFAULT_REQUEST_TIMEOUT).toString()));
		String className = cl.getOptionValue("c", "");
		String methodName = cl.getOptionValue("m", "");
		String[] methodArgs = cl.getArgs();

		if ("".equals(className) || "".equals(methodName)) {
			HelpFormatter hFormatter = new HelpFormatter();
			hFormatter.printHelp(String.format("java %s [opts] [args]", HinemosManagerCli.class.getName()), options);
			System.exit(1);
		}

		return new InvokeInfo(className, methodName, methodArgs);
	}

}
