package com.clustercontrol.notify.monitor.model;

import javax.persistence.*;

import com.clustercontrol.accesscontrol.annotation.HinemosObjectPrivilege;
import com.clustercontrol.accesscontrol.bean.RoleIdConstant;
import com.clustercontrol.bean.HinemosModuleConstant;
import com.clustercontrol.accesscontrol.bean.PrivilegeConstant.ObjectPrivilegeMode;
import com.clustercontrol.accesscontrol.model.ObjectPrivilegeTargetEntity;
import com.clustercontrol.commons.util.HinemosEntityManager;
import com.clustercontrol.commons.util.JpaTransactionManager;
import com.clustercontrol.jobmanagement.factory.CreateJobSession;
import com.clustercontrol.jobmanagement.model.JobSessionEntity;
import com.clustercontrol.jobmanagement.model.JobSessionJobEntity;
import com.clustercontrol.maintenance.model.MaintenanceInfoEntity;
import com.clustercontrol.monitor.run.model.MonitorInfoEntity;
import com.clustercontrol.notify.monitor.util.OwnerDeterminDispatcher;

import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;


/**
 * The persistent class for the cc_status_info database table.
 * 
 */
@Entity
@Table(name="cc_status_info")
@HinemosObjectPrivilege(
		objectType=HinemosModuleConstant.MONITOR)
@AttributeOverride(name="objectId",
column=@Column(name="monitor_id", insertable=false, updatable=false))
public class StatusInfoEntity extends ObjectPrivilegeTargetEntity {
	private static final long serialVersionUID = 1L;
	private StatusInfoEntityPK id;
	private String application;
	private Timestamp expirationDate;
	private Integer expirationFlg;
	private Timestamp generationDate;
	private String message;
	private String messageId;
	private Timestamp outputDate;
	private Integer priority;

	@Deprecated
	public StatusInfoEntity() {
	}

	public StatusInfoEntity(StatusInfoEntityPK pk) {
		this.setId(pk);
		EntityManager em = new JpaTransactionManager().getEntityManager();
		em.persist(this);
		this.setObjectId(this.getId().getMonitorId());
		
		// 通知元が監視の場合
		if(this.getId().getPluginId().matches(HinemosModuleConstant.MONITOR+".*")){
			// オブジェクト権限チェックのため、cc_monitor_infoのowner_role_idを設定する
			MonitorInfoEntity monitorInfoEntity
			= ((HinemosEntityManager)em).find(MonitorInfoEntity.class, this.getId().getMonitorId(), ObjectPrivilegeMode.NONE);
			if (monitorInfoEntity != null && monitorInfoEntity.getOwnerRoleId() != null) {
				this.setOwnerRoleId(monitorInfoEntity.getOwnerRoleId());
			} else {
				this.setOwnerRoleId(RoleIdConstant.INTERNAL);
			}
		}
		// 通知元がジョブの場合
		else if(this.getId().getPluginId().matches(HinemosModuleConstant.JOB+".*")) {
			// オブジェクト権限チェックのため、cc_job_session_jobのowner_role_idを設定する
			JobSessionEntity jobSessionEntity 
			= ((HinemosEntityManager)em).find(JobSessionEntity.class, this.getId().getMonitorId(), ObjectPrivilegeMode.NONE);
			
			List<JobSessionJobEntity> jobSessionJobEntityList = jobSessionEntity.getJobSessionJobEntities();
			Iterator<JobSessionJobEntity> it = jobSessionJobEntityList.iterator();
			
			JobSessionJobEntity jobSessionJobEntity = null;
			while(it.hasNext()) {
				jobSessionJobEntity = it.next();
				// ジョブユニット「ROOT」でない場合はwhileを抜ける
				// ジョブユニットが「ROOT」であるものは、オーナーロールIDが「ALL_USERS」であるため
				if(!jobSessionJobEntity.getId().getJobunitId().matches(CreateJobSession.TOP_JOBUNIT_ID)) {
					break;
				}
			}
			
			if (jobSessionJobEntity != null && jobSessionJobEntity.getOwnerRoleId() != null) {
				this.setOwnerRoleId(jobSessionJobEntity.getOwnerRoleId());
			} else {
				this.setOwnerRoleId(RoleIdConstant.INTERNAL);
			}
		}
		// 通知元がメンテナンスの場合
		else if(this.getId().getPluginId().matches(HinemosModuleConstant.SYSYTEM_MAINTENANCE)){
			// オブジェクト権限チェックのため、cc_maintenance_infoのowner_role_idを設定する
			MaintenanceInfoEntity maintenanceInfoEntity
			= ((HinemosEntityManager)em).find(MaintenanceInfoEntity.class, this.getId().getMonitorId(), ObjectPrivilegeMode.NONE);
			if (maintenanceInfoEntity != null && maintenanceInfoEntity.getOwnerRoleId() != null) {
				this.setOwnerRoleId(maintenanceInfoEntity.getOwnerRoleId());
			} else {
				this.setOwnerRoleId(RoleIdConstant.INTERNAL);
			}
		}
		// 通知元が上記以外のプラグインIDの場合
		// ここでオプション等の任意ステータス（設定に紐付かないタイプのもの）についてオーナロールを決定することが可能。
		// プラグインIDをキーにして、ObjectSharingServiceにIEventOwnerDeterminerの実装クラスを登録し、
		// そこでオーナロールを決定する。
		// 事前に当該プラグインIDに対応するIEventOwnerDeterminerの実装クラスが登録されていない場合には、
		// オーナはINTERNALとなる。
		// 但し、このルートではリフレクションを使うため、多くのステータス通知が発生するオプションでこの機構を使うと
		// 性能的に問題になる可能性が高いため、そういう場合にはここに分岐を作って直接処理をするべき。
		else {
			setOwnerRoleId(OwnerDeterminDispatcher.getOptionalStatusOwner(pk));
		}
	}

	public StatusInfoEntity(String facilityId,
			String monitorId,
			String monitorDetailId,
			String pluginId) {
		this(new StatusInfoEntityPK(facilityId, monitorId, monitorDetailId, pluginId));
	}


	@EmbeddedId
	public StatusInfoEntityPK getId() {
		return this.id;
	}

	public void setId(StatusInfoEntityPK id) {
		this.id = id;
	}


	public String getApplication() {
		return this.application;
	}

	public void setApplication(String application) {
		this.application = application;
	}


	@Column(name="expiration_date")
	public Timestamp getExpirationDate() {
		return this.expirationDate;
	}

	public void setExpirationDate(Timestamp expirationDate) {
		this.expirationDate = expirationDate;
	}


	@Column(name="expiration_flg")
	public Integer getExpirationFlg() {
		return this.expirationFlg;
	}

	public void setExpirationFlg(Integer expirationFlg) {
		this.expirationFlg = expirationFlg;
	}


	@Column(name="generation_date")
	public Timestamp getGenerationDate() {
		return this.generationDate;
	}

	public void setGenerationDate(Timestamp generationDate) {
		this.generationDate = generationDate;
	}


	public String getMessage() {
		return this.message;
	}

	public void setMessage(String message) {
		this.message = message;
	}


	@Column(name="message_id")
	public String getMessageId() {
		return this.messageId;
	}

	public void setMessageId(String messageId) {
		this.messageId = messageId;
	}


	@Column(name="output_date")
	public Timestamp getOutputDate() {
		return this.outputDate;
	}

	public void setOutputDate(Timestamp outputDate) {
		this.outputDate = outputDate;
	}


	public Integer getPriority() {
		return this.priority;
	}

	public void setPriority(Integer priority) {
		this.priority = priority;
	}

}