package com.clustercontrol.jobmanagement.model;

import java.io.Serializable;
import javax.persistence.*;

import com.clustercontrol.commons.util.JpaTransactionManager;

import java.sql.Timestamp;
import java.util.List;


/**
 * The persistent class for the cc_job_session database table.
 * 
 */
@Entity
@Table(name="cc_job_session")
public class JobSessionEntity implements Serializable {
	private static final long serialVersionUID = 1L;
	private String sessionId;
	private String jobId;
	private String jobunitId;
	private Integer operationFlg;
	private Timestamp scheduleDate;
	private String triggerInfo;
	private Integer triggerType;
	private String filename;
	private List<JobSessionJobEntity> jobSessionJobEntities;

	@Deprecated
	public JobSessionEntity() {
	}

	public JobSessionEntity(String sessionId) {
		this.setSessionId(sessionId);
		EntityManager em = new JpaTransactionManager().getEntityManager();
		em.persist(this);
	}


	@Id
	@Column(name="session_id")
	public String getSessionId() {
		return this.sessionId;
	}

	public void setSessionId(String sessionId) {
		this.sessionId = sessionId;
	}


	@Column(name="job_id")
	public String getJobId() {
		return this.jobId;
	}

	public void setJobId(String jobId) {
		this.jobId = jobId;
	}


	@Column(name="jobunit_id")
	public String getJobunitId() {
		return this.jobunitId;
	}

	public void setJobunitId(String jobunitId) {
		this.jobunitId = jobunitId;
	}


	@Column(name="operation_flg")
	public Integer getOperationFlg() {
		return this.operationFlg;
	}

	public void setOperationFlg(Integer operationFlg) {
		this.operationFlg = operationFlg;
	}


	@Column(name="schedule_date")
	public Timestamp getScheduleDate() {
		return this.scheduleDate;
	}

	public void setScheduleDate(Timestamp scheduleDate) {
		this.scheduleDate = scheduleDate;
	}


	@Column(name="trigger_info")
	public String getTriggerInfo() {
		return this.triggerInfo;
	}

	public void setTriggerInfo(String triggerInfo) {
		this.triggerInfo = triggerInfo;
	}


	@Column(name="trigger_type")
	public Integer getTriggerType() {
		return this.triggerType;
	}

	public void setTriggerType(Integer triggerType) {
		this.triggerType = triggerType;
	}


	@Column(name="filename")
	public String getFilename() {
		return this.filename;
	}

	public void setFilename(String filename) {
		this.filename = filename;
	}


	//bi-directional many-to-one association to JobSessionJobEntity
	@OneToMany(mappedBy="jobSessionEntity", cascade=CascadeType.ALL, orphanRemoval=true, fetch=FetchType.LAZY)
	public List<JobSessionJobEntity> getJobSessionJobEntities() {
		return this.jobSessionJobEntities;
	}

	public void setJobSessionJobEntities(List<JobSessionJobEntity> jobSessionJobEntities) {
		this.jobSessionJobEntities = jobSessionJobEntities;
	}

}