/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.mapping;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.jpasecurity.ExceptionFactory;
import net.sf.jpasecurity.mapping.EntityLifecycleMethods;
import net.sf.jpasecurity.mapping.EntityListener;

public abstract class AbstractEntityListenerAdapter
implements EntityListener {
    private final EntityLifecycleMethods entityLifecycleMethods;
    private final ExceptionFactory exceptionFactory;

    public AbstractEntityListenerAdapter(EntityLifecycleMethods entityLifecycleMethods, ExceptionFactory factory) {
        this.entityLifecycleMethods = entityLifecycleMethods;
        this.exceptionFactory = factory;
    }

    public void prePersist(Object entity) {
        if (this.entityLifecycleMethods.getPrePersistMethod() != null) {
            this.invoke(this.entityLifecycleMethods.getPrePersistMethod(), entity);
        }
    }

    public void postPersist(Object entity) {
        if (this.entityLifecycleMethods.getPostPersistMethod() != null) {
            this.invoke(this.entityLifecycleMethods.getPostPersistMethod(), entity);
        }
    }

    public void preRemove(Object entity) {
        if (this.entityLifecycleMethods.getPreRemoveMethod() != null) {
            this.invoke(this.entityLifecycleMethods.getPreRemoveMethod(), entity);
        }
    }

    public void postRemove(Object entity) {
        if (this.entityLifecycleMethods.getPostRemoveMethod() != null) {
            this.invoke(this.entityLifecycleMethods.getPostRemoveMethod(), entity);
        }
    }

    public void preUpdate(Object entity) {
        if (this.entityLifecycleMethods.getPreUpdateMethod() != null) {
            this.invoke(this.entityLifecycleMethods.getPreUpdateMethod(), entity);
        }
    }

    public void postUpdate(Object entity) {
        if (this.entityLifecycleMethods.getPostUpdateMethod() != null) {
            this.invoke(this.entityLifecycleMethods.getPostUpdateMethod(), entity);
        }
    }

    public void postLoad(Object entity) {
        if (this.entityLifecycleMethods.getPostLoadMethod() != null) {
            this.invoke(this.entityLifecycleMethods.getPostLoadMethod(), entity);
        }
    }

    private void invoke(Method method, Object entity) {
        try {
            this.fireEvent(method, entity);
        }
        catch (IllegalAccessException e) {
            throw this.exceptionFactory.createRuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw this.exceptionFactory.createRuntimeException(e.getTargetException());
        }
    }

    protected abstract void fireEvent(Method var1, Object var2) throws IllegalAccessException, InvocationTargetException;
}

