/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.bean;

import com.clustercontrol.util.Messages;

/**
 * 一括制御状態の定数を定義するクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class CollectiveRunStatusConstant {
	/** 待機中(状態の種別) */
	public static final int TYPE_WAITING = 0;

	/** 実行中(状態の種別) */
	public static final int TYPE_RUNNING = 100;

	/** 終了(状態の種別) */
	public static final int TYPE_END = 300;

	/** 実行失敗(状態の種別) */
	public static final int TYPE_ERROR = 400;

	/** 待機中(状態の種別) */
	public static final String STRING_WAITING = Messages.getString("waiting");

	/** 実行中(状態の種別) */
	public static final String STRING_RUNNING = Messages.getString("running");

	/** 終了(状態の種別) */
	public static final String STRING_END = Messages.getString("end");

	/** 実行失敗(状態の種別) */
	public static final String STRING_ERROR = Messages.getString("run.error");

	/**
	 * 種別から文字列に変換します。<BR>
	 * 
	 * @param type
	 * @return 一括制御の実行状態を示す文字列
	 */
	public static String typeToString(int type) {
		if (type == TYPE_RUNNING) {
			return STRING_RUNNING;
		} else if (type == TYPE_END) {
			return STRING_END;
		} else if (type == TYPE_WAITING) {
			return STRING_WAITING;
		} else if (type == TYPE_ERROR) {
			return STRING_ERROR;
		}
		return "";
	}

	/**
	 * 文字列から種別に変換します。<BR>
	 * 
	 * @param 一括制御の実行状態を示す文字列
	 * @return　type
	 */
	public static int stringToType(String string) {
		if (string.equals(STRING_RUNNING)) {
			return TYPE_RUNNING;
		} else if (string.equals(STRING_END)) {
			return TYPE_END;
		} else if (string.equals(STRING_WAITING)) {
			return TYPE_WAITING;
		} else if (string.equals(STRING_ERROR)) {
			return TYPE_ERROR;
		}
		return -1;
	}
}