package com.clustercontrol.notify.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NotifyGroupIdGenerator {
	private static Log m_log = LogFactory.getLog( NotifyGroupIdGenerator.class );

	/**
	 * 通知グループIDを生成します。(ジョブ定義用)
	 * 
	 * @return 通知グループID
	 */
	public static String createNotifyGroupIdJob(String jobunitId, String jobId, Integer noticeType){

		String ret = com.clustercontrol.bean.HinemosModuleConstant.JOB_MST
		+ "-"+jobunitId
		+"-"+jobId
		+"-"+noticeType.toString();

		return ret;
	}

	/**
	 * 通知グループIDを生成します。(ジョブセッション用)
	 * 
	 * @return 通知グループID
	 */
	public static String createNotifyGroupIdJobInfo(String sessionId, String jobunitId, String jobId, Integer noticeType){

		String ret = com.clustercontrol.bean.HinemosModuleConstant.JOB_SESSION
		+"-"+sessionId
		+"-"+jobunitId
		+"-"+jobId
		+"-"+noticeType.toString();

		return ret;
	}

	/**
	 * 通知グループIDを生成します。(数値監視、真偽値監視用)
	 * 
	 * @param monitorTypeId 監視タイプID
	 * @param monitorID 監視項目ID
	 * @return 通知グループID
	 * 
	 * @see com.clustercontrol.bean.HinemosModuleConstant
	 */
	public static String createNotifyGroupId(String monitorTypeId, String monitorID){
		return  createNotifyGroupId(monitorTypeId, monitorID, 0);
	}

	/**
	 * 通知グループIDを生成します。(文字列監視用)
	 * 
	 * @return 通知グループID
	 */
	public static  String createNotifyGroupId(String monitorTypeId, String monitorID, Integer orderNo){
		/* monitorTypeが存在するかチェック */
		if(!com.clustercontrol.bean.HinemosModuleConstant.isExist(monitorTypeId)){

			return null;
		}

		String ret =  monitorTypeId + "-" + monitorID + "-" + orderNo.toString();

		return ret;
	}
}
