#!/bin/bash

# Copyright (C) since 2006 NTT DATA Corporation
# 
# This program is free software; you can redistribute it and/or
# Modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation, version 2.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details

# bash configuration
SCRIPT_DIR=$(cd $(dirname $0);pwd)
. ${SCRIPT_DIR}/../hinemos.cfg
. ${SCRIPT_DIR}/../sbin/hinemos_utility.sh

export PROG=`basename $0`
DIR=`dirname $0`
USER=`/usr/bin/whoami`
HOST=`hostname`

########################################
#  Local Variable
########################################


########################################
#  Local Message
########################################

# INFO
MSG_I001="${PROG}    : startup Hinemos Manager"
MSG_I002="${PROG} -c : startup Hinemos Manager after temporally data is removed"
MSG_I003="waiting for Hinemos Manager to start..."
MSG_I004="Hinemos Manager started"
MSG_I005="${PROG} -M : startup Hinemos Manager(maintenance-mode)"

# WARN
#MSG_W001="xxx"

# ERROR
MSG_E001="usage : ${PROG} [-c|-M]"
MSG_E002="incorrect user(${USER}). please check variable HINEMOS_JBOSS_USER (${HINEMOS_HOME}/hinemos.cfg).";
MSG_E003="failed to start Hinemos Manager"

########################################
# Function
########################################


########################################
# SHELL
########################################

#
# check argument
#
for ARGS in "$@"
do
	case ${ARGS} in
		-c)
			JBOSS_OPTS="${JBOSS_OPTS} -c"
			;;
		-M)
			JBOSS_OPTS="${JBOSS_OPTS} -M"
			;;
		*)
			Logging "${MSG_E001}"
			Logging "${MSG_I001}"
			Logging "${MSG_I002}"
			Logging "${MSG_I005}"
			exit -1
			;;
	esac
done

#
# check user executed
#
if [ "x"${USER} != "x"${HINEMOS_JBOSS_USER} ]
then
	Logging "${MSG_E002}"
	exit -2
fi

Logging "${MSG_I003}" && echo

# startup PostgreSQL
${HINEMOS_HOME}/bin/pg_start.sh

RET=$?
if [ ${RET} -ne 0 ]
then
	echo && Logging "${MSG_E003}"
	exit ${RET}
fi

# startup JBoss
${HINEMOS_HOME}/bin/jboss_start.sh ${JBOSS_OPTS}

RET=$?
if [ ${RET} -ne 0 ]
then
	echo && Logging "${MSG_E003}"
	exit ${RET}
fi

echo && Logging "${MSG_I004}"

exit 0

