/* 
  
Copyright (C) since 2009 NTT DATA Corporation 
  
This program is free software; you can redistribute it and/or 
Modify it under the terms of the GNU General Public License  
as published by the Free Software Foundation, version 2. 
  
This program is distributed in the hope that it will be 
 useful, but WITHOUT ANY WARRANTY; without even the implied  
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR  
 PURPOSE.  See the GNU General Public License for more details. 
  
*/ 
package com.clustercontrol.repository.bean;

import java.io.Serializable;

/**
 * このクラスは、リポジトリプロパティ[ファイルシステム]のクラスです。
 * NodeDataクラスのメンバ変数として利用されます。
 * @since 0.8
 */
public class NodeFilesystemInfo implements Serializable
{
	private java.lang.Integer fsIndex = new Integer(-1);
	private java.lang.String fsMountPoint = "";
	private java.lang.String fsDisplayName = "";
	private java.lang.String fsType = "";
	private java.lang.String fsSnmpOid = "";
	private java.lang.String fsDescription = "";

	/**
	 * 空のコンストラクタです。setterで要素を追加して下さい。
	 */
	public NodeFilesystemInfo()
	{
	}

	/**
	 * コンストラクトする際に、値をセットする事ができます。
	 * @param fsIndex
	 * @param fsMountPoint
	 * @param fsDisplayName
	 * @param fsType
	 * @param fsSnmpOid
	 * @param fsDescription
	 */
	public NodeFilesystemInfo(java.lang.Integer fsIndex,java.lang.String fsMountPoint,java.lang.String fsDisplayName,java.lang.String fsType,java.lang.String fsSnmpOid,java.lang.String fsDescription )
	{
		setFsIndex(fsIndex);
		setFsMountPoint(fsMountPoint);
		setFsDisplayName(fsDisplayName);
		setFsType(fsType);
		setFsSnmpOid(fsSnmpOid);
		setFsDescription(fsDescription);
	}

	/**
	 * NodeFilesystemDataインスタンスのコピーを生成する時に利用します。
	 * @param otherData
	 */
	public NodeFilesystemInfo( NodeFilesystemInfo otherData )
	{
		setFsIndex(otherData.getFsIndex());
		setFsMountPoint(otherData.getFsMountPoint());
		setFsDisplayName(otherData.getFsDisplayName());
		setFsType(otherData.getFsType());
		setFsSnmpOid(otherData.getFsSnmpOid());
		setFsDescription(otherData.getFsDescription());
	}

	
	/**
	 * ファイルシステムINDEXのgetterです。
	 * @return Integer
	 */
	public java.lang.Integer getFsIndex()
	{
		return this.fsIndex;
	}
	
	/**
	 * ファイルシステムINDEXのsetterです。
	 * not nullです。
	 * @param fsIndex
	 */
	public void setFsIndex( java.lang.Integer fsIndex )
	{
		this.fsIndex = fsIndex;
	}

	/**
	 * マウント位置のgetterです。
	 * @return String
	 */
	public java.lang.String getFsMountPoint()
	{
		return this.fsMountPoint;
	}
	/**
	 * マウント位置のsetterです。
	 * not nullです。
	 * @param fsMountPoint
	 */
	public void setFsMountPoint( java.lang.String fsMountPoint )
	{
		this.fsMountPoint = fsMountPoint;
	}

	/**
	 * 表示名のgetterです。
	 * @return String
	 */
	public java.lang.String getFsDisplayName()
	{
		return this.fsDisplayName;
	}
	
	/**
	 * 表示名のsetterです。
	 * not nullです。
	 * @param fsDisplayName
	 */
	public void setFsDisplayName( java.lang.String fsDisplayName )
	{
		this.fsDisplayName = fsDisplayName;
	}

	/**
	 * ファイルシステム種別のgetterです。
	 * @return String
	 */
	public java.lang.String getFsType()
	{
		return this.fsType;
	}
	/**
	 * ファイルシステム種別のsetterです。
	 * @param fsType
	 */
	public void setFsType( java.lang.String fsType )
	{
		this.fsType = fsType;
	}

	/**
	 * ファイルシステムOIDのgetterです。
	 * @return String
	 */
	public java.lang.String getFsSnmpOid()
	{
		return this.fsSnmpOid;
	}
	
	/**
	 * ファイルシステムOIDのsetterです。
	 * @param fsSnmpOid
	 */
	public void setFsSnmpOid( java.lang.String fsSnmpOid )
	{
		this.fsSnmpOid = fsSnmpOid;
	}

	/**
	 * 説明のgetterです。
	 * @return String
	 */
	public java.lang.String getFsDescription()
	{
		return this.fsDescription;
	}
	/**
	 * 説明のsetterです。
	 * @param fsDescription
	 */
	public void setFsDescription( java.lang.String fsDescription )
	{
		this.fsDescription = fsDescription;
	}

	@Override
	public String toString()
	{
		StringBuffer str = new StringBuffer("{");

		str.append("fsIndex=" + getFsIndex() + " " + "fsMountPoint=" + getFsMountPoint() + " " + "fsDisplayName=" + getFsDisplayName() + " " + "fsType=" + getFsType() + " " + "fsSnmpOid=" + getFsSnmpOid() + " " + "fsDescription=" + getFsDescription());
		str.append('}');

		return(str.toString());
	}

	@Override
	public boolean equals( Object pOther )
	{
		if( pOther instanceof NodeFilesystemInfo )
		{
			NodeFilesystemInfo lTest = (NodeFilesystemInfo) pOther;
			boolean lEquals = true;

			if( this.fsIndex == null )
			{
				lEquals = lEquals && ( lTest.fsIndex == null );
			}
			else
			{
				lEquals = lEquals && this.fsIndex.equals( lTest.fsIndex );
			}
			if( this.fsMountPoint == null )
			{
				lEquals = lEquals && ( lTest.fsMountPoint == null );
			}
			else
			{
				lEquals = lEquals && this.fsMountPoint.equals( lTest.fsMountPoint );
			}
			if( this.fsDisplayName == null )
			{
				lEquals = lEquals && ( lTest.fsDisplayName == null );
			}
			else
			{
				lEquals = lEquals && this.fsDisplayName.equals( lTest.fsDisplayName );
			}
			if( this.fsType == null )
			{
				lEquals = lEquals && ( lTest.fsType == null );
			}
			else
			{
				lEquals = lEquals && this.fsType.equals( lTest.fsType );
			}
			if( this.fsSnmpOid == null )
			{
				lEquals = lEquals && ( lTest.fsSnmpOid == null );
			}
			else
			{
				lEquals = lEquals && this.fsSnmpOid.equals( lTest.fsSnmpOid );
			}
			if( this.fsDescription == null )
			{
				lEquals = lEquals && ( lTest.fsDescription == null );
			}
			else
			{
				lEquals = lEquals && this.fsDescription.equals( lTest.fsDescription );
			}

			return lEquals;
		}
		else
		{
			return false;
		}
	}

	@Override
	public int hashCode()
	{
		int result = 17;

		result = 37*result + ((this.fsIndex != null) ? this.fsIndex.hashCode() : 0);

		result = 37*result + ((this.fsMountPoint != null) ? this.fsMountPoint.hashCode() : 0);

		result = 37*result + ((this.fsDisplayName != null) ? this.fsDisplayName.hashCode() : 0);

		result = 37*result + ((this.fsType != null) ? this.fsType.hashCode() : 0);

		result = 37*result + ((this.fsSnmpOid != null) ? this.fsSnmpOid.hashCode() : 0);

		result = 37*result + ((this.fsDescription != null) ? this.fsDescription.hashCode() : 0);

		return result;
	}

}
