/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.bean;

import java.util.ArrayList;

/**
 * 
 * イベント・ステータスの一覧情報を保持するクラス<BR>
 * イベント・ステータスの一覧は、それぞれ下記のオブジェクトが格納されたArrayListである<BR>
 * ジョブ履歴の一覧情報も保持する<BR>
 * 仮想化操作の一覧情報も保持する<BR>
 * 
 * <li> イベント：com.clustercontrol.monitor.ejb.entity.StatusInfoData
 * <li> ステータス：com.clustercontrol.monitor.ejb.entity.EventLogData
 * 
 * @version 2.1.1
 * @since 2.1.1
 */
public class ViewListInfo implements java.io.Serializable{
	
	private static final long serialVersionUID = 859993588207224113L;
	
	protected int critical = 0;		//重要度:危険数
	protected int warning = 0;			//重要度:警告数
	protected int info = 0;			//重要度:通知数
	protected int unKnown = 0;			//重要度:不明数
	protected int total = 0;			//合計数
	
	/** 
	 *
	 * イベント・ステータスの一覧
	 * 
	 * @see com.clustercontrol.monitor.ejb.entity.StatusInfoData
	 * @see com.clustercontrol.monitor.ejb.entity.EventLogData
	 *  
	 */
	protected ArrayList list;
    
	/**
	 * @return
	 */
	public int getCritical() {
		return critical;
	}
	
	/**
	 * @param critical
	 */
	public void setCritical(int critical) {
		this.critical = critical;
	}
	
	/**
	 * @return
	 */
	public ArrayList getList() {
		return list;
	}
	
	/**
	 * @param eventList
	 */
	public void setList(ArrayList list) {
		this.list = list;
	}
	
	/**
	 * @return
	 */
	public int getInfo() {
		return info;
	}
	
	/**
	 * @param info
	 */
	public void setInfo(int info) {
		this.info = info;
	}
	
	/**
	 * @return
	 */
	public int getTotal() {
		return total;
	}
	
	/**
	 * @param total
	 */
	public void setTotal(int total) {
		this.total = total;
	}
	
	/**
	 * @return
	 */
	public int getUnKnown() {
		return unKnown;
	}
	
	/**
	 * @param unKnown
	 */
	public void setUnKnown(int unKnown) {
		this.unKnown = unKnown;
	}
	
	/**
	 * @return
	 */
	public int getWarning() {
		return warning;
	}
	
	/**
	 * @param warning
	 */
	public void setWarning(int warning) {
		this.warning = warning;
	}
}