/*
Copyright (C) 2010 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
*/
package com.clustercontrol.ws.endpoint;

import java.util.ArrayList;
import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.MonitorDuplicateException;
import com.clustercontrol.MonitorNotFoundException;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.port.ejb.session.MonitorPortControllerLocal;
import com.clustercontrol.port.ejb.session.MonitorPortControllerUtil;

/**
 * ポート監視用のWebAPIエンドポイント
 */
@javax.jws.WebService
public class MonitorPortEndpoint {
	protected static Log m_log = LogFactory.getLog( MonitorPortEndpoint.class );
	
	public String echo(String str) {
		return str + ", " + str;
	}
	
	private MonitorPortControllerLocal getMonitorPortControllerLocal() throws HinemosUnknownException {
		MonitorPortControllerLocal monitor = null;
		try {
			monitor = MonitorPortControllerUtil.getLocalHome().create();
		} catch (CreateException e) {
			m_log.error("getMonitorPortControllerLocal CreateException : " + e,e);
			throw new HinemosUnknownException(e.getMessage(), e);
		} catch (NamingException e) {
			m_log.error("getMonitorPortControllerLocal NamingException : " + e,e);
			throw new HinemosUnknownException(e.getMessage(), e);
		}
		return monitor;
	}
	
	/**
	 * port監視情報を登録します。
	 * 
	 * @param info 通知情報
	 * @return 登録に成功した場合、true
	 * @throws MonitorDuplicateException 
	 * @throws HinemosUnknownException
	 */
	public boolean addPortMonitor(MonitorInfo info) throws MonitorDuplicateException, HinemosUnknownException {
		String id = null;
		if (info != null) {
			id = info.getMonitorId();
		}
		m_log.debug("addPortMonitor : monitorId=" + id + ", monitorInfo=" + info);
		MonitorPortControllerLocal monitor = getMonitorPortControllerLocal();
		return monitor.addPort(info);
	}
	
	/**
	 * port監視情報を更新します。
	 * 
	 * @param info 通知情報
	 * @return 変更に成功した場合、true
	 * @throws MonitorNotFoundException 
	 * @throws HinemosUnknownException
	 */
	public boolean modifyPortMonitor(MonitorInfo info) throws MonitorNotFoundException, HinemosUnknownException {
		String id = null;
		if (info != null) {
			id = info.getMonitorId();
		}
		m_log.debug("modifyPortMonitor : monitorId=" + id + ", monitorInfo=" + info);
		MonitorPortControllerLocal monitor = getMonitorPortControllerLocal();
		return monitor.modifyPort(info);
	}
	
	/**
	 * port監視情報を削除します。
	 * 
	 * @param monitorId 監視項目ID
	 * @return 削除に成功した場合、true
	 * @throws MonitorNotFoundException
	 * @throws HinemosUnknownException 
	 */
	public boolean deletePortMonitor(String monitorId) throws MonitorNotFoundException, HinemosUnknownException {
		m_log.debug("deletePortMonitor : monitorId=" + monitorId);
		MonitorPortControllerLocal monitor = getMonitorPortControllerLocal();
		return monitor.deletePort(monitorId);
	}
	
	/**
	 * port監視情報を返します。
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param monitorId 監視項目ID
	 * @return port監視情報
	 * @throws MonitorNotFoundException
	 * @throws HinemosUnknownException 
	 */
	public MonitorInfo getPortMonitor(String monitorId) throws MonitorNotFoundException, HinemosUnknownException {
		m_log.debug("getPortMonitor : monitorId=" + monitorId);
		MonitorPortControllerLocal monitor = getMonitorPortControllerLocal();
		return monitor.getPort(monitorId);
	}

	/**
	 * port監視一覧リストを返します。
	 * 
	 * @return MonitorInfoの配列
	 * @throws MonitorNotFoundException 
	 * @throws HinemosUnknownException
	 */
	public ArrayList<MonitorInfo> getPortList() throws MonitorNotFoundException, HinemosUnknownException{
		m_log.debug("getPortList : ");
		MonitorPortControllerLocal monitor = getMonitorPortControllerLocal();
		return monitor.getPortList();
	}
	
}
