/*
 
Copyright (C) 2010 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.selfcheck.jmx;

import org.jboss.system.ServiceMBean;

public interface SelfCheckServiceMBean extends ServiceMBean {
	
	//
	// SelfCheck Service Attribute
	//
	public void setLastMonitorDate(String date) throws Exception;
	public String getLastMonitorDate();
	
	public void setStartupDelaySec(int sec);
	public int getStartupDelaySec();
	
	public void setIntervalSec(int sec);
	public int getIntervalSec();
	
	public void setAlertThreshold(int count);
	public int getAlertThreshold();
	
	public void setThreadPoolSize(int size);
	public int getThreadPoolSize();
	
	//
	// SelfCheck Notification Attribute
	//
	public void setEvent(boolean enable);
	public boolean getEvent();
	
	public void setSyslog(boolean enable);
	public boolean getSyslog();
	
	public void setSyslogHost(String[] hosts);
	public String[] getSyslogHost();
	
	public void setSyslogPort(int port);
	public int getSyslogPort();
	
	public void setSyslogFacility(String facility);
	public String getSyslogFacility();
	
	public void setSyslogSeverity(String severity);
	public String getSyslogSeverity();
	
	public void setMail(boolean enable);
	public boolean getMail();
	
	public void setMailAddress(String[] addresses);
	public String[] getMailAddress();
	
	//
	// SNMP Configuration to 127.0.0.1 (Hinemos Manager)
	//
	public void setSnmpHost(String host);
	public String getSnmpHost();
	
	public void setSnmpCommunity(String community);
	public String getSnmpCommunity();
	
	public void setSnmpPort(int port);
	public int getSnmpPort();
	
	public void setSnmpVersion(String version);
	public String getSnmpVersion();
	
	public void setSnmpTimeoutMSec(int msec);
	public int getSnmpTimeoutMSec();
	
	public void setSnmpRetries(int count);
	public int getSnmpRetries();
	
	//
	// monitor java vm heap
	//
	public void setJVMHeapMonitoring(boolean enable);
	public boolean getJVMHeapMonitoring();
	
	public void setJVMHeapThresholdMByte(int mbyte);
	public int getJVMHeapThresholdMByte();
	
	//
	// monitor filesystem on 127.0.0.1 (Hinemos Manager)
	//
	public void setFileSystemMonitoring(boolean enable);
	public boolean getFileSystemMonitoring();
	
	public void setMountPointDatabase(String mountPoint);
	public String getMountPointDatabase();
	
	public void setMountPointLog(String mountPoint);
	public String getMountPointLog();
	
	public void setFileSystemDBThresholdPer(int percent);
	public int getFileSystemDBThresholdPer();
	
	public void setFileSystemLogThresholdPer(int percent);
	public int getFileSystemLogThresholdPer();
	
	//
	// monitor ram memory on 127.0.0.1 (Hinemos Manager)
	//
	public void setSwapOutMonitoring(boolean enable);
	public boolean getSwapOutMonitoring();
	
	//
	// monitor datasource
	//
	public void setDatasourceMonitoring(boolean enable);
	public boolean getDatasourceMonitoring();
	
	public void setJndiDatasourceHinemos(String jndi);
	public String getJndiDatasourceHinemos();
	
	//
	// monitor java scheduler
	//
	public void setSchedulerMonitoring(boolean enable);
	public boolean getSchedulerMonitoring();
	
	public void setSchedulerDelayThresholdSec(int sec);
	public int getSchedulerDelayThresholdSec();
	
	public void setJndiDBMSScheduler(String jndi);
	public String getJndiDBMSScheduler();
	
	public void setJndiRAMScheduler(String jndi);
	public String getJndiRAMScheduler();
	
	public String getTriggerGroupDBMS();
	public void setTriggerGroupDBMS(String group);
	
	public String getTriggerNameDBMS();
	public void setTriggerNameDBMS(String name);
	
	public String getTriggerGroupRAM();
	public void setTriggerGroupRAM(String group);
	
	public String getTriggerNameRAM();
	public void setTriggerNameRAM(String name);
	
	//
	// monitor java messaging service
	//
	public void setJMSMonitoring(boolean enable);
	public boolean getJMSMonitoring();
	
	public void setJMSMessageCountThreshold(int count);
	public int getJMSMessageCountThreshold();
	
	public void setMonitorQueue(String[] queues);
	public String[] getMonitorQueue();
	
	public void setMonitorTopic(String[] topics);
	public String[] getMonitorTopic();
	
	//
	// monitor external programs
	//
	public void setSyslogForwardMonitoring(boolean enable);
	public boolean getSyslogForwardMonitoring();
	
	public void setSyslogForwardHost(String[] hosts);
	public String[] getSyslogForwardHost();
	
	//
	// monitor log table
	//
	public void setLogTableSizeMonitoring(boolean enable);
	public boolean getLogTableSizeMonitoring();
	
	public void setJndiLogTableDS(String jndi);
	public String getJndiLogTableDS();
	
	// event
	public void setTableNameEventLog(String tableName);
	public String getTableNameEventLog();
	
	public void setTableNameEventLogDesc(String desc);
	public String getTableNameEventLogDesc();
	
	public void setThresholdEventLog(long threshold);
	public long getThresholdEventLog();
	
	public void setThresholdTypeEventLog(int type);
	public int getThresholdTypeEventLog();
	
	// collected resource
	public void setTableNameCollectedResourceLog(String tableName);
	public String getTableNameCollectedResourceLog();
	
	public void setTableNameCollectedResourceLogDesc(String desc);
	public String getTableNameCollectedResourceLogDesc();
	
	public void setThresholdCollectedResourceLog(long threshold);
	public long getThresholdCollectedResourceLog();
	
	public void setThresholdTypeCollectedResourceLog(int type);
	public int getThresholdTypeCollectedResourceLog();
	
	// job
	public void setTableNameJobLog(String tableName);
	public String getTableNameJobLog();
	
	public void setTableNameJobLogDesc(String desc);
	public String getTableNameJobLogDesc();
	
	public void setThresholdJobLog(long threshold);
	public long getThresholdJobLog();
	
	public void setThresholdTypeJobLog(int type);
	public int getThresholdTypeJobLog();
	
	// collective run
	public void setTableNameCrunLog(String tableName);
	public String getTableNameCrunLog();
	
	public void setTableNameCrunLogDesc(String desc);
	public String getTableNameCrunLogDesc();
	
	public void setThresholdCrunLog(long threshold);
	public long getThresholdCrunLog();
	
	public void setThresholdTypeCrunLog(int type);
	public int getThresholdTypeCrunLog();
	
	//
	// JMS api
	//
	public String showStatus();
	
}
