/*
                                                                                                                                                                 
Copyright (C) 2008 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performance.operator;

/**
 * 時間平均を求めます。
 */
public class TimeMean extends Operator {
	@Override
	public double calc() throws CollectedDataNotFoundException, InvalidValueException{
		double perfData;
				
		double uptimeDiff = getDifferenceValue("var0");
	
		// 分母が0の場合（更新されていない場合）
		if(uptimeDiff == 0){
			return Double.NaN;
		}
		
		double valDirff = getDifferenceValue("var1");
		
		perfData = (valDirff)/uptimeDiff * 100.0D;  // アップタイムは10ミリ秒単位のため
		
		return perfData;
	}
}
