/*

 Copyright (C) 2009 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.notify.util;

import java.sql.Timestamp;
import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.RenotifyTypeConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.notify.bean.NotifyRequestMessage;
import com.clustercontrol.notify.ejb.entity.MonitorStatusLocal;
import com.clustercontrol.notify.ejb.entity.MonitorStatusPK;
import com.clustercontrol.notify.ejb.entity.MonitorStatusUtil;
import com.clustercontrol.notify.ejb.entity.NotifyHistoryLocal;
import com.clustercontrol.notify.ejb.entity.NotifyHistoryPK;
import com.clustercontrol.notify.ejb.entity.NotifyHistoryUtil;

public class NotifyExecutor {
	/** ログ出力のインスタンス */
	private static Log m_log = LogFactory.getLog( NotifyExecutor.class );

	public static boolean notifyCheck(String facilityId, String pluginId, String monitorId, String notifyId, int priority, Date outputDate, boolean priorityChangeFlag){

		NotifyHistoryPK pk = new NotifyHistoryPK(facilityId, pluginId, monitorId, notifyId);
		try {
			// 重要度変化があった場合
			if(priorityChangeFlag == true){
				m_log.debug("priorityChangeFlag == true. remove entity. " + pk);
				
				// 通知履歴の該当タプルを削除する
				try {
					NotifyHistoryUtil.getLocalHome().findByPrimaryKey(pk).remove();
				} catch (FinderException e) {
					m_log.debug(e.getMessage() + " NotifyHistory=" + pk);
					// 何もしない
				} catch (RemoveException e) {
					m_log.warn(e.getMessage() + " NotifyHistory=" + pk);
					// 何もしない
				}
			}

			// 重要度単位の通知フラグを確認する	
			// 重要度単位の有効無効を確認
			if(NotifyInfoCache.getDetailValidFlg(notifyId, priority).intValue() == ValidConstant.TYPE_INVALID){
				// 無効の場合は通知しない
				m_log.debug("ValidFlg is invalid. " + pk + ", priority = " + priority);
				return false;
			}

			// 通知条件である同一重要度カウンタ数を満たしているか確認
			// 同一重要度カウンタを保持する監視結果ステータス情報を検索
			MonitorStatusPK mspk = new MonitorStatusPK(facilityId, pluginId, monitorId);
			MonitorStatusLocal monitorStatus = null;
			try {
				monitorStatus = MonitorStatusUtil.getLocalHome().findByPrimaryKey(mspk);
			} catch (FinderException e1) {
				// 存在しない場合は、常に通知
				m_log.debug("notify OK. (MONITOR STATUS NOT FOUND)." + pk);
				return true;
			}
			
			if(monitorStatus.getCounter() >= NotifyInfoCache.getInitialCount(notifyId)){
				// カウンタが条件を満たしている場合
				m_log.debug("counter check. " + monitorStatus.getCounter() + " >= " + NotifyInfoCache.getInitialCount(notifyId) + "  " + pk);
				
				try{
					// 通知履歴の該当タプルを検索
					NotifyHistoryLocal history = NotifyHistoryUtil.getLocalHome().findByPrimaryKey(pk);
					
					try {
						Thread.sleep(10);
					} catch (Exception e) {
						
					}
					
					// 該当のタプルが存在する場合
					// 再通知種別を確認
					if(NotifyInfoCache.getRenotifyType(notifyId) == RenotifyTypeConstant.TYPE_NO_NOTIFY){
						// 再通知なしの場合
						m_log.debug("notify NG. (RENOTIFY NO)." + pk);
						return false;
					} else if(NotifyInfoCache.getRenotifyType(notifyId) == RenotifyTypeConstant.TYPE_ALWAYS_NOTIFY){
						// 常に再通知の場合
//						history.setLastNotify(new Timestamp(outputDate.getTime())); 更新の必要がない
						m_log.debug("notify OK. (RENOTIFY ALWAYS)." + pk);
						return true;
					} else {
						
						if(outputDate.getTime() >= 
							(history.getLastNotify().getTime() + (NotifyInfoCache.getRenotifyPeriod(notifyId) * 60 * 1000l))){
							m_log.debug("update notify history." + pk);
							// 通知時刻が抑制期間を超えている場合
							history.setLastNotify(new Timestamp(outputDate.getTime()));
							m_log.debug("notify OK. (RENOTIFY PERIOD)." + pk);
							return true;
						} else {
							m_log.debug("notify NG. (RENOTIFY PERIOD)." + pk);
							return false;
						}
					}
				} catch (FinderException e) {
					// 該当のタプルが存在しない場合
					// 初回通知
					m_log.debug("first notify. " + pk + ", priority = " + priority);
					
					// 新規に通知履歴を作成する
					NotifyHistoryUtil.getLocalHome().create(
								facilityId, pluginId, monitorId, notifyId, new Timestamp(outputDate.getTime()));

					m_log.debug("notify OK. (PRIORITY CHANGE)." + pk);
					return true;
				}
			} else {
				m_log.debug("notify NG. (PRIORITY CHANGE)." + pk);
				return false;
			}
			
		} catch (EJBException e) {
			m_log.error(e.getMessage(), e);
		} catch (NamingException e) {
			m_log.error(e.getMessage(), e);
		} catch (CreateException e) {
			m_log.error(e.getMessage(), e);
		}

		m_log.error("notify OK. (cause unexpected errors)" + pk);
		return true;
	}
	
	
	public static boolean execNotify(Notifier notifier, NotifyRequestMessage message) throws Exception{
		boolean isNotify = notifyCheck(
				message.getOutputInfo().getFacilityId(), 
				message.getOutputInfo().getPluginId(), 
				message.getOutputInfo().getMonitorId(), 
				message.getNotifyId(), 
				message.getOutputInfo().getPriority(), 
				message.getOutputDate(), 
				message.isPriorityChangeFlag());
		
		if(isNotify){
			// 通知を実行
			try {
				notifier.notify(message);
				return true;
			} catch (Exception e) {
				throw e;
			}
		} else {
			return false;
		}
	}
}
