/*
 
 Copyright (C) 2008 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.notify.mail.ejb.entity;

import java.rmi.RemoteException;
import java.sql.Timestamp;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

/**
 * メールテンプレート情報のCMP Entity Bean
 * 
 * @ejb.bean name="MailTemplateInfo"
 *     jndi-name="MailTemplateInfo"
 *     type="CMP"
 *     primkey-field="mailTemplateId"
 *     schema="MailTemplateInfo"
 *     cmp-version="2.x"
 *     data-source="java:/HinemosDS"
 *     view-type="local" 
 *         
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 *    
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 *    
 * @jboss.persistence
 *    datasource="java:/HinemosDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_mail_template_info"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 *           
 * @ejb.persistence 
 *     table-name="cc_mail_template_info"
 *     
 * @ejb.finder 
 *     query="SELECT OBJECT(a) FROM MailTemplateInfo as a"  
 *     signature="java.util.Collection findAll()"
 *     
 * @ejb.finder
 *    query=""
 *    signature="java.util.Collection findAllOrderByMailTemplateId()"
 *    
 * @jboss.query
 *    query="SELECT OBJECT(a) FROM MailTemplateInfo as a ORDER BY a.mailTemplateId"
 *    signature="java.util.Collection findAllOrderByMailTemplateId()"
 *           
 * @ejb.permission
 *     unchecked="true"
 *     
 * @ejb.pk class="java.lang.String"
 */
public abstract class MailTemplateInfoBean implements EntityBean {
	
	/* (非 Javadoc)
	 * @see javax.ejb.EntityBean#setEntityContext(javax.ejb.EntityContext)
	 */
	public void setEntityContext(EntityContext ctx) throws EJBException, RemoteException {
	}
	
	/* (非 Javadoc)
	 * @see javax.ejb.EntityBean#unsetEntityContext()
	 */
	public void unsetEntityContext() throws EJBException, RemoteException {
	}
	
	/**
	 * メールテンプレート情報を生成します。
	 * 
	 * @ejb.create-method
	 * 
	 * @param mailTemplateId メールテンプレートID
	 * @param description 説明
	 * @param subject 件名
	 * @param body 本文
	 * @param regDate 作成日時
	 * @param updateDate 最終変更日時
	 * @param regUser 新規作成ユーザ
	 * @param updateUser 最終変更ユーザ
	 * @return プライマリキー
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 * @see com.clustercontrol.bean.StatusValidPeriodConstant
	 * @see com.clustercontrol.bean.StatusExpirationConstant
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.bean.ExclusionConstant
	 */
	public java.lang.String ejbCreate(
			String mailTemplateId,
			String description,
			String subject,
			String body,
			Timestamp regDate,  
			Timestamp updateDate, 
			String regUser, 
			String updateUser) throws javax.ejb.CreateException {
		
		setMailTemplateId(mailTemplateId);
		setDescription(description);
		setSubject(subject);
		setBody(body);
		setRegDate(regDate);
		setUpdateDate(updateDate);
		setRegUser(regUser);
		setUpdateUser(updateUser);
		return null;
	}
	
	public void ejbRemove() throws RemoveException, EJBException, RemoteException {
	}
	
	public void ejbActivate() throws EJBException, RemoteException {
	}
	
	public void ejbPassivate() throws EJBException, RemoteException {
	}
	
	public void ejbLoad() throws EJBException, RemoteException {
	}
	
	public void ejbStore() throws EJBException, RemoteException {
	}
	
	/**
	 * メールテンプレートIDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="mail_template_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return メールテンプレートID
	 */
	public abstract String getMailTemplateId();
	
	/**
	 * メールテンプレートIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param mailTemplateId メールテンプレートID
	 */
	public abstract void setMailTemplateId(String mailTemplateId);
	
	/**
	 * 説明を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="description"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     
	 *
	 * @ejb.interface-method
	 * 
	 * @return 説明
	 */
	public abstract String getDescription();
	
	/**
	 * 説明を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param description 説明
	 */
	public abstract void setDescription(String description);
	
	/**
	 * 件名を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="subject"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 件名
	 */
	public abstract String getSubject();
	
	/**
	 * 件名を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param subject 件名
	 */
	public abstract void setSubject(String subject);
	
	/**
	 * 本文を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="body"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="text"
	 *     
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 本文
	 */
	public abstract String getBody();
	
	/**
	 * 本文を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param body 本文
	 */
	public abstract void setBody(String body);
	
	/**
	 * 作成日時を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="reg_date"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     
	 *  
	 * @ejb.interface-method
	 * 
	 * @return regDate 作成日時
	 */
	public abstract Timestamp getRegDate();

	/**
	 * 作成日時を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param regDate 作成日時
	 */
	public abstract void setRegDate(Timestamp regDate);
	
	/**
	 * 最終変更日時を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="update_date"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 最終変更日時
	 */
	public abstract Timestamp getUpdateDate();
	
	/**
	 * 最終変更日時を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param updateDate 最終変更日時
	 */
	public abstract void setUpdateDate(Timestamp updateDate);
	
	/**
	 * 新規作成ユーザを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="reg_user"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     
	 *
	 * @ejb.interface-method
	 * 
	 * @return 新規作成ユーザ
	 */
	public abstract java.lang.String getRegUser();
	   
	/**
	 * 新規作成ユーザを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param regUser 新規作成ユーザ
	 */
	public abstract void setRegUser(java.lang.String regUser);	

	/**
	 * 最終変更ユーザを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="update_user"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     
	 *
	 * @ejb.interface-method
	 * 
	 * @return 最終変更ユーザ
	 */
	public abstract java.lang.String getUpdateUser();
	   
	/**
	 * 最終変更ユーザを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param updateUser 最終変更ユーザ 
	 */
	public abstract void setUpdateUser(java.lang.String updateUser);
	
	/**
	 * このCMPのデータをフィールドとして持つDataオブジェクト（MailTemplateInfoData）を返します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns Dataオブジェクト（MailTemplateInfoData）
	 */
	public abstract MailTemplateInfoData getData();
}
