/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.factory;

import java.util.Collection;
import java.util.Iterator;

import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.NotifyNotFoundException;
import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.notify.ejb.entity.NotifyRelationInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyRelationInfoUtil;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * システム通知情報を削除するクラスです。
 *
 * @version 3.0.0
 * @since 3.0.0
 */
public class DeleteNotifyRelation {
	
	/** ログ出力のインスタンス。 */
	protected static Log m_log = LogFactory.getLog( DeleteNotifyRelation.class );
	
	/**
	 * 通知グループIDを基に関連情報を削除します。
	 * <p>
	 * <ol>
	 *  <li>通知グループIDを基に関連情報を削除します。</li>
	 * </ol>
	 * 
	 * @param notifyGroupId 削除対象の通知グループID
	 * @return 削除に成功した場合、<code> true </code>
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws NamingException
	 */
	public boolean delete(String notifyGroupId) throws NotifyNotFoundException, RemoveException, NamingException {
		//アクセスロック
		AccessLock.lock(AccessLock.NOTIFY);
		
		try 
		{
			
			Collection<NotifyRelationInfoLocal> notifies =  NotifyRelationInfoUtil.getLocalHome().findByNotifyGroupId(notifyGroupId);
			
			Iterator<NotifyRelationInfoLocal> it = notifies.iterator();
			
			while(it.hasNext()){
				
				 NotifyRelationInfoLocal detail = it.next();
				 
				 detail.remove();
			}
			
			
		} catch (FinderException e) {
			AplLogger apllog = new AplLogger("NOTIFY", "notify");
//			String[] args = { notifyId };
//			apllog.put("SYS", "003", args);
			m_log.debug("delete():" + e.getMessage());
			throw new NotifyNotFoundException(e.getMessage(), e);
		} catch (RemoveException e) {
			AplLogger apllog = new AplLogger("NOTIFY", "notify");
//			String[] args = { notifyId };
//			apllog.put("SYS", "003", args);
			m_log.debug("delete():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
			AplLogger apllog = new AplLogger("NOTIFY", "notify");
//			String[] args = { notifyId };
//			apllog.put("SYS", "003", args);
			m_log.debug("delete():" + e.getMessage());
			throw e;
		}
		return true;
	}
	
	/**
	 * syslog-ng監視の通知グループIDを全て削除します。
	 * 
	 * @return 削除に成功した場合、<code> true </code>
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws NamingException
	 */
	public boolean deleteSyslogNG() throws NotifyNotFoundException, RemoveException, NamingException {
		//アクセスロック
		AccessLock.lock(AccessLock.NOTIFY);
		
		try 
		{
			
			for(Object detailObj : NotifyRelationInfoUtil.getLocalHome().findAll()){
				
				NotifyRelationInfoLocal detail = (NotifyRelationInfoLocal)detailObj;
				 if(detail.getNotifyGroupId().startsWith("MON_LOG")){
					 
					 detail.remove();
					 
				 }
				 
			}
		} catch (FinderException e) {
			AplLogger apllog = new AplLogger("NOTIFY", "notify");
//			String[] args = { notifyId };
//			apllog.put("SYS", "003", args);
			m_log.debug("delete():" + e.getMessage());
			throw new NotifyNotFoundException(e.getMessage(), e);
		} catch (RemoveException e) {
			AplLogger apllog = new AplLogger("NOTIFY", "notify");
//			String[] args = { notifyId };
//			apllog.put("SYS", "003", args);
			m_log.debug("delete():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
			AplLogger apllog = new AplLogger("NOTIFY", "notify");
//			String[] args = { notifyId };
//			apllog.put("SYS", "003", args);
			m_log.debug("delete():" + e.getMessage());
			throw e;
		}
		return true;
	}
	
	/**
	 * 通知IDを基に抑制情報を削除します。
	 * <p>
	 * <ol>
	 *  <li>通知IDを基に抑制情報を削除します。</li>
	 * </ol>
	 * 
	 * @param notifyId 削除対象の通知ID
	 * @return 削除に成功した場合、<code> true </code>
	 */
	public boolean deleteBaseOnNotifyId(String notifyId) {
		//アクセスロック
		AccessLock.lock(AccessLock.NOTIFY);
		
		try 
		{
			// 通知IDを基に関連情報を取得
			Collection<NotifyRelationInfoLocal> ct = NotifyRelationInfoUtil.getLocalHome().findByNotifyId(notifyId);
			
			if(ct.size() != 0){
				/*
				 * TODO : 監視で使用していることを知らせたい場合は、ここでExceptionなどを返す実装をおこなう
				 */
			}
			
			Iterator<NotifyRelationInfoLocal> it = ct.iterator();
			
			while(it.hasNext()){
				
				NotifyRelationInfoLocal relation = it.next();
				relation.remove();
			}
			
			
		} catch (RemoveException e) {
			m_log.debug("deleteBaseOnNotifyId():" + e.getMessage(),e);
		} catch (FinderException e) {
			m_log.debug("deleteBaseOnNotifyId():" + e.getMessage(),e);
		} catch (NamingException e) {
			m_log.debug("deleteBaseOnNotifyId():" + e.getMessage(),e);
		}
		return true;
	}

}
