/*
Copyright (C) 2010 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
*/

package com.clustercontrol.nodemap.ejb.entity;

import java.lang.String;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 *
 * <!-- begin-user-doc --> マップ描画対象ノード（スコープ）の位置情報を保持するEntityBean '<em><b>FacilityPositionBean</b></em>'. <!-- end-user-doc --> *
 *
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="FacilityPosition"
 *	jndi-name="FacilityPosition"
 *	type="CMP" 
 *  schema="FacilityPosition" 
 *  cmp-version="2.x"
 *  data-source="java:/HinemosDS"
 *  primkey-field="mapId","elementId"
 * 
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.persistence 
 *   table-name="cc_map_position" 
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM FacilityPosition as a"  
 *    signature="java.util.Collection findAll()"  
 *    
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM FacilityPosition as a WHERE a.mapId = ?1"  
 *    signature="java.util.Collection findByMapId(java.lang.String mapId)"  
 *
 * @ejb.pk class="com.clustercontrol.nodemap.ejb.entity.FacilityPositionPK"
 *
 * <!-- end-xdoclet-definition -->
 * @generated
 **/
public abstract class FacilityPositionBean implements javax.ejb.EntityBean {
	protected static Log m_log = LogFactory.getLog( FacilityPositionBean.class );
	
	/**
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public FacilityPositionPK ejbCreate(
			String map_id,
			String element_id,
			Integer x, 
			Integer y
	) throws javax.ejb.CreateException {
		setMapId(map_id);
		setElementID(element_id);
		setX(x);
		setY(y);
		return null;
	}
	
	
	/**
	 * <!-- begin-user-doc -->
	 * The container invokes this method immediately after it calls ejbCreate.
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void ejbPostCreate() throws javax.ejb.CreateException {
		// begin-user-code
		// end-user-code
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * CMP Field map_id
	 *
	 * Returns the map_id
	 * @return the map_id
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="map_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 * 
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getMapId();
	
	/**
	 * <!-- begin-user-doc -->
	 * Sets the map_id
	 * 
	 * @param java.lang.String the new map_id value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setMapId(java.lang.String map_id);
	
	/**
	 * <!-- begin-user-doc -->
	 * CMP Field element_id
	 *
	 * Returns the element_id
	 * @return the element_id
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="element_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 *
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getElementID();
	
	/**
	 * <!-- begin-user-doc -->
	 * Sets the element_id
	 * 
	 * @param java.lang.String the new element_id value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setElementID(java.lang.String element_id);
	
	/**
	 * <!-- begin-user-doc -->
	 * CMP Field x
	 *
	 * Returns the x
	 * @return the x
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="x"
	 *     jdbc-type="INTEGER"
	 *     sql-type="integer"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract Integer getX();
	
	/**
	 * <!-- begin-user-doc -->
	 * Sets the x
	 * 
	 * @param java.lang.Integer the new x
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setX(Integer x);

	/**
	 * <!-- begin-user-doc -->
	 * CMP Field y
	 *
	 * Returns the y
	 * @return the y
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="y"
	 *     jdbc-type="INTEGER"
	 *     sql-type="integer"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract Integer getY();
	
	/**
	 * <!-- begin-user-doc -->
	 * Sets the y
	 * 
	 * @param java.lang.Integer the new y
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setY(Integer y);
}
