package com.clustercontrol.monitor.run.util;

import java.util.concurrent.Callable;

import javax.naming.InitialContext;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

import com.clustercontrol.monitor.run.bean.MonitorRunResultInfo;
import com.clustercontrol.monitor.run.factory.RunMonitor;

/**
 * 
 * 各監視を実行するクラスです。
 * 
 * @version 2.4.0
 * @since 2.4.0
 */
public class CallableTask implements Callable<MonitorRunResultInfo>{

	private RunMonitor m_runMonitor;
	private String m_facilityId;
	
	/**
	 * コンストラクタ
	 * @param facilityId
	 */
	public CallableTask(RunMonitor monitor, String facilityId) {
		m_runMonitor = monitor;
		m_facilityId = facilityId;
	}
	
	/**
	 * 各監視を実行します。
	 * 
	 * @see #setMonitorInfo(String, String)
	 */
	public MonitorRunResultInfo call() throws Exception {
		
		// 結果を格納
		MonitorRunResultInfo info = new MonitorRunResultInfo();
		
		// トランザクションを開始
		TransactionManager tm = null;
		Transaction oldTx = null;
		Boolean ret = false;
		try{
			// TransactionManagerを取得
			InitialContext context = new InitialContext();
			tm = (TransactionManager)context.lookup("java:/TransactionManager");
			
			// 実行中のスレッドがトランザクションに関連付けられている場合は、トランザクションを退避 
			if(tm.getTransaction() != null){
				oldTx = tm.suspend();
			}
			
			// トランザクション開始
			if(tm.getTransaction() == null){
				tm.begin();	
			}
	
			// 各監視処理を実行し、実行の可否を格納
			ret = m_runMonitor.collect(m_facilityId);
	
			// コミット
			tm.commit();
			
		}finally{
			// 一時停止していたトランザクションを再開
			if(oldTx != null){
				tm.resume(oldTx);
			}
		}
		
		// 監視値より判定結果を取得
		Integer checkResult = m_runMonitor.getCheckResult(ret);
			
		info.setRet(ret);
		info.setCheakResult(checkResult);
		info.setMessage(m_runMonitor.getMessage(checkResult));
		info.setMessageId(m_runMonitor.getMessageId(checkResult));
		info.setMessageOrg(m_runMonitor.getMessageOrg(checkResult));
//		info.setJobRunInfo(m_runMonitor.getJobRunInfo(checkResult));
		info.setPriority(m_runMonitor.getPriority(checkResult));
		info.setNodeDate(m_runMonitor.getNodeDate());
		
		// 通知グループIDをセットする
		// SNMP文字列監視のマルチスレッド化対応用の実装
		info.setNotifyGroupId(m_runMonitor.getNotifyGroupId());
		
		return info;
	}

}
