/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.collectiverun.bean.CommandInfo;
import com.clustercontrol.collectiverun.bean.CommandParameterInfo;
import com.clustercontrol.collectiverun.bean.EndStatusInfo;
import com.clustercontrol.collectiverun.bean.ItemConstant;
import com.clustercontrol.collectiverun.bean.ItemInfo;
import com.clustercontrol.collectiverun.bean.ParameterInfo;
import com.clustercontrol.collectiverun.bean.ParameterSelectInfo;
import com.clustercontrol.collectiverun.bean.TreeItem;
import com.clustercontrol.collectiverun.bean.TypeInfo;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdParamMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunEndMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamSelectMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunTypeMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunTypeMstUtil;
import com.clustercontrol.util.Messages;

/**
 * マスタ検索クラス
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class SelectMaster {
//    protected static Log m_log = LogFactory.getLog( SelectMaster.class );

	/**
	 * ツリー情報取得
	 * 
	 * @param locale
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public TreeItem getTree(Locale locale) throws FinderException, NamingException {
		
		//TreeItemの最上位インスタンスを作成
	    ItemInfo info = new ItemInfo();
	    info.setName("");
	    info.setType(ItemConstant.TYPE_COMPOSITE);
	    info.setOrderNo(0);
		TreeItem tree = new TreeItem(null, info);
		
		//コマンドツリーのルートを生成
	    info = new ItemInfo();
	    info.setName(ItemConstant.STRING_COMMADN_COMPOSITE);
	    info.setType(ItemConstant.TYPE_COMMADN_COMPOSITE);
	    info.setOrderNo(0);
		TreeItem cmdTree = new TreeItem(tree, info);
		
		try {
			Collection collection = CRunTypeMstUtil.getLocalHome().findAll();
			if(collection != null){
				Iterator itr = collection.iterator();
				while(itr.hasNext()){
				    //種別を取得
					CRunTypeMstLocal type = (CRunTypeMstLocal)itr.next();
				    //種別ツリーを作成
					createTypeTree(type, cmdTree, locale);
				}
			}
			
			//パラメータツリーのルートを生成
			info = new ItemInfo();
			info.setName(ItemConstant.STRING_PARAMETER_COMPOSITE);
			info.setType(ItemConstant.TYPE_PARAMETER_COMPOSITE);
			info.setOrderNo(1);
			TreeItem paramTree = new TreeItem(tree, info);
			
			collection = CRunParamMstUtil.getLocalHome().findAll();
			if(collection != null){
				Iterator itr = collection.iterator();
				while(itr.hasNext()){
				    //種別を取得
					CRunParamMstLocal param = (CRunParamMstLocal)itr.next();
				    //種別ツリーを作成
					createParamTree(param, paramTree, locale);
				}
			}
		} catch (FinderException e) {
			throw new FinderException("SelectMaster.getTree() find error : " + e.getMessage());
		} catch (NamingException e) {
			throw e;
		}
		
		return tree;
	}
	
	/**
	 * 種別情報作成
	 * 
	 * @param type
	 * @param parent
	 * @param locale
	 */
	protected void createTypeTree(CRunTypeMstLocal type, TreeItem parent, Locale locale) {

		//TypeInfoを作成
		TypeInfo info = new TypeInfo();
		info.setId(type.getType_id());
		info.setName(Messages.getString(type.getName_id(), locale));
		info.setType(ItemConstant.TYPE_TYPE);
		info.setOrderNo(type.getOrder_no().intValue());
		
		TreeItem item = new TreeItem(parent, info);
		
		//種別に紐づく全コマンドマスタ取得
	    Collection collection = type.getCmdMst();
	    if(collection != null && collection.size() > 0){
			Iterator itr = collection.iterator();
			while(itr.hasNext()){			    
			    //コマンドマスタを取得
				CRunCmdMstLocal cmd = (CRunCmdMstLocal)itr.next();
				
				//コマンドツリーを作成
				createCommandTree(cmd, item, locale);
			}
	    }
	}

	/**
	 * コマンド情報作成
	 * 
	 * @param cmd
	 * @param parent
	 * @param locale
	 */
	protected void createCommandTree(CRunCmdMstLocal cmd, TreeItem parent, Locale locale) {

		//CommandInfoを作成
		CommandInfo info = new CommandInfo();
		info.setId(cmd.getCommand_id());
		info.setName(Messages.getString(cmd.getName_id(), locale));
		info.setType(ItemConstant.TYPE_COMMAND);
		info.setOrderNo(cmd.getOrder_no().intValue());
		info.setCommand(cmd.getCommand());
		info.setCommandType(cmd.getCommand_type().intValue());

		//コマンドに紐づく終了状態マスタ取得
		ArrayList<EndStatusInfo> list = new ArrayList<EndStatusInfo>();
	    Collection collection = cmd.getEndMst();
	    if(collection != null && collection.size() > 0){
			Iterator itr = collection.iterator();
			while(itr.hasNext()){			    
			    //終了状態マスタを取得
				CRunEndMstLocal endStatus = (CRunEndMstLocal)itr.next();
				
				//EndStatusInfoを作成
				EndStatusInfo endStatusInfo = new EndStatusInfo();
				endStatusInfo.setEndStatus(endStatus.getEnd_status().intValue());
				endStatusInfo.setStartRangeValue(endStatus.getEnd_value_from().intValue());
				endStatusInfo.setEndRangeValue(endStatus.getEnd_value_to().intValue());
				
				list.add(endStatusInfo);
			}
	    }
	    info.setEndStatus(list);
	    
		TreeItem item = new TreeItem(parent, info);
		
		//コマンドに紐づくコマンドパラメータマスタ取得
	    collection = cmd.getCmdParamMst();
	    if(collection != null && collection.size() > 0){
			Iterator itr = collection.iterator();
			while(itr.hasNext()){			    
			    //コマンドパラメータマスタを取得
				CRunCmdParamMstLocal param = (CRunCmdParamMstLocal)itr.next();
				
				//コマンドパラメータツリーを作成
				createCommandParameterTree(param, item, locale);
			}
	    }
	}
	
	/**
	 * コマンドパラメータ情報作成
	 * 
	 * @param cmdParam
	 * @param parent
	 * @param locale
	 */
	protected void createCommandParameterTree(CRunCmdParamMstLocal cmdParam, TreeItem parent, Locale locale) {

		//CommandParameterInfoを作成
		CommandParameterInfo info = new CommandParameterInfo();
		info.setId(cmdParam.getParam_id());
		
		CRunParamMstLocal param = cmdParam.getParamMst();
		info.setName(Messages.getString(param.getName_id(), locale));
		
		info.setPrefix(cmdParam.getParam_prefix());
		info.setOrderNo(cmdParam.getOrder_no().intValue());
		info.setType(ItemConstant.TYPE_COMMAND_PARAMETER);

		new TreeItem(parent, info);
	}
	
	/**
	 * パラメータ情報作成
	 * 
	 * @param param
	 * @param parent
	 * @param locale
	 */
	protected void createParamTree(CRunParamMstLocal param, TreeItem parent, Locale locale) {

		//ParameterInfoを作成
		ParameterInfo info = new ParameterInfo();
		info.setId(param.getParam_id());
		info.setName(Messages.getString(param.getName_id(), locale));
		info.setType(ItemConstant.TYPE_PARAMETER);
		info.setParamType(param.getParam_type().intValue());
		
		TreeItem item = new TreeItem(parent, info);
		
		//パラメータに紐づく選択肢マスタ取得
	    Collection collection = param.getParamSelectMst();
	    if(collection != null && collection.size() > 0){
			Iterator itr = collection.iterator();
			while(itr.hasNext()){			    
			    //コマンドマスタを取得
				CRunParamSelectMstLocal select = (CRunParamSelectMstLocal)itr.next();
				
				//選択肢ツリーを作成
				createParamSelectTree(select, item, locale);
			}
	    }
	}
	
	/**
	 * パラメータ選択肢情報作成
	 * 
	 * @param select
	 * @param parent
	 * @param locale
	 */
	protected void createParamSelectTree(CRunParamSelectMstLocal select, TreeItem parent, Locale locale) {

		//ParameterSelectInfoを作成
		ParameterSelectInfo info = new ParameterSelectInfo();
		info.setId(select.getParam_id());
		info.setName(Messages.getString(select.getName_id(), locale));
		info.setType(ItemConstant.TYPE_SELECT_ITEM);
		info.setOrderNo(select.getOrder_no().intValue());
		info.setValue(select.getParam_value());
		
		new TreeItem(parent, info);
	}
	
	/**
	 * 種別IDから文字列を取得
	 * 
	 * @param typeId
	 * @param locale
	 * @return
	 * @throws FinderException 
	 * @throws NamingException 
	 */
	public static String typeIdToString(String typeId, Locale locale) throws FinderException, NamingException {
		String string = null;
		
		CRunTypeMstLocal type = null;
		try {
			type = CRunTypeMstUtil.getLocalHome().findByPrimaryKey(typeId);
		} catch (FinderException e) {
			throw new FinderException("SelectMaster.typeIdToString() find error : " + "typeId=" + typeId);
		} catch (NamingException e) {
			throw e;
		}
		
		if(type != null){
			string = Messages.getString(type.getName_id(), locale);
		}
		return string;
	}
	
	/**
	 * 文字列から種別IDを取得
	 * 
	 * @param string
	 * @param locale
	 * @return
	 * @throws FinderException 
	 * @throws NamingException 
	 */
	public static String stringToTypeId(String string, Locale locale) throws FinderException, NamingException {

		Collection collection = null;
		try {
			collection = CRunTypeMstUtil.getLocalHome().findAll();
		} catch (FinderException e) {
			throw new FinderException("SelectMaster.stringToTypeId() find error : " + e.getMessage());
		} catch (NamingException e) {
			throw e;
		}
		if(collection != null){
			Iterator itr = collection.iterator();
			while(itr.hasNext()){
			    //種別を取得
				CRunTypeMstLocal type = (CRunTypeMstLocal)itr.next();
				String name = Messages.getString(type.getName_id(), locale);
				if(name.equals(string))
					return type.getType_id();
			}
		}
		return null;
	}
	
	/**
	 * 種別文字列リストを取得
	 * 
	 * @param locale
	 * @return
	 * @throws FinderException 
	 * @throws NamingException 
	 */
	public static List<String> getTypeStringList(Locale locale) throws FinderException, NamingException {
		ArrayList<String> list = new ArrayList<String>();
		
		Collection collection = null;
		try {
			collection = CRunTypeMstUtil.getLocalHome().findAllSortOrderNo();
		} catch (FinderException e) {
			throw new FinderException("SelectMaster.getTypeStringList() find error : " + e.getMessage());
		} catch (NamingException e) {
			throw e;
		}
		if(collection != null){
			Iterator itr = collection.iterator();
			while(itr.hasNext()){
			    //種別を取得
				CRunTypeMstLocal type = (CRunTypeMstLocal)itr.next();
				String name = Messages.getString(type.getName_id(), locale);
				list.add(name);
			}
		}
		return list;
	}
	
	/**
	 * 種別情報のハッシュマップを取得
	 * 
	 * @param locale
	 * @return
	 * @throws FinderException 
	 * @throws NamingException 
	 */
	public static HashMap<String, String> getTypeHashMap(Locale locale) throws FinderException, NamingException {
		HashMap<String, String> map = new HashMap<String, String>();
		
		Collection collection = null;
		try {
			collection = CRunTypeMstUtil.getLocalHome().findAll();
		} catch (FinderException e) {
			throw new FinderException("SelectMaster.HashMap() find error : " + e.getMessage());
		} catch (NamingException e) {
			throw e;
		}
		if(collection != null){
			Iterator itr = collection.iterator();
			while(itr.hasNext()){
			    //種別を取得
				CRunTypeMstLocal type = (CRunTypeMstLocal)itr.next();
				map.put(type.getType_id(), Messages.getString(type.getName_id(), locale));
				map.put(Messages.getString(type.getName_id(), locale), type.getType_id());
			}
		}
		return map;
	}
}
