/*
 
Copyright (C) since 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.ejb.entity;

/**
 * アクセスロックのCMP Entity Beanクラス<BR>
 * 
 * @ejb.bean name="AccessLock"
 *    jndi-name="AccessLock"
 *    type="CMP"
 *    view-type="local" 
 *    schema="AccessLock" 
 *    cmp-version="2.x"
 *    primkey-field="lock_id"
 * 
 * @ejb.persistence 
 *    table-name="public.cc_acc_lock" 
 * 
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM AccessLock as a"  
 *    signature="java.util.Collection findAll()"  
 * 
 * @ejb.finder
 *    query=""
 *    signature="java.lang.String findByLockIdForUpdate(java.lang.String lock_id)"
 * 
 * @jboss.query
 *    query="SELECT OBJECT(a) FROM AccessLock as a WHERE a.lock_id = ?1"  
 *    signature="java.lang.String findByLockIdForUpdate(java.lang.String lock_id)"  
 * 
 * @ejb.pk class="java.lang.String"
 * 
 * @ejb.permission
 *     unchecked="true"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 *    
  * @jboss.depends
 *    name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 * 
 * @jboss.read-ahead
 *    strategy="on-load"
 * 
 * @jboss.persistence
 *    datasource="java:/HinemosDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_acc_lock"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 *    row-locking="true"
 */
public abstract class AccessLockBean implements javax.ejb.EntityBean {

	/**
	 * アクセスロックを生成します。<BR>
	 * 
	 * @ejb.create-method 
	 * 
	 * @param lock_id ロックID
	 * @return プライマリーキー
	 * @throws javax.ejb.CreateException
	 */
	public java.lang.String ejbCreate(
			String lock_id
			) throws javax.ejb.CreateException {
		setLock_id(lock_id);
		return null;
	}

	/**
	 * ロックIDを返します。<BR>
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="lock_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return ロックID
	 */
	public abstract java.lang.String getLock_id();

	/**
	 * ロックIDを設定します。<BR>
	 * 
	 * @ejb.interface-method
	 * 
	 * @param lock_id ロックID
	 */
	public abstract void setLock_id(java.lang.String lock_id);

}
