/*

Copyright (C) 2010 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/
package com.clustercontrol;

/**
 * facilityIDが重複している場合に利用するException
 * @version 3.2.0
 */
public class NotifyDuplicateException extends HinemosException {
	
	private String m_notifyId = null;
	
	/**
	 * FacilityDuplicateExceptionコンストラクタ
	 */
	public NotifyDuplicateException() {
		super();
	}
	
	/**
	 * FacilityDuplicateExceptionコンストラクタ
	 * @param messages
	 */
	public NotifyDuplicateException(String messages) {
		super(messages);
	}
	
	/**
	 * FacilityDuplicateExceptionコンストラクタ
	 * @param e
	 */
	public NotifyDuplicateException(Throwable e) {
		super(e);
	}
	
	/**
	 * FacilityDuplicateExceptionコンストラクタ
	 * @param messages
	 * @param e
	 */
	public NotifyDuplicateException(String messages, Throwable e) {
		super(messages, e);
	}

	public String getNotifyId() {
		return m_notifyId;
	}

	public void setNotifyId(String notifyId) {
		m_notifyId = notifyId;
	}
}
