/*
 
Copyright (C) 2008 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.snmptrap.factory;

import java.sql.Timestamp;
import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterData;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterUtil;
import com.clustercontrol.util.apllog.AplLogger;

/**
 *MIBマスター情報を登録するクラス<BR>
 *
 * @version 3.0.0
 * @since 2.4.0
 * @author Yosuke
 */
public class AddMibMaster {
	
	protected static Log m_log = LogFactory.getLog( AddMibMaster.class );
	
	/** 監視情報ビーン */
	protected SnmpTrapMibMasterData m_MibData;
	
    /**
     * MIBマスター情報を登録します。
     * @param mibData  登録するMIBマスター
     * @param user     登録実行ユーザ
     * @return
     * @throws CreateException
     * @throws NotSupportedException
     * @throws RollbackException
     * @throws HeuristicMixedException
     * @throws HeuristicRollbackException
     * @throws SystemException
     * @throws InvalidTransactionException
     * @throws NamingException
     * @throws FinderException
     */
	public boolean add(SnmpTrapMibMasterData mibData, String user) throws CreateException, NotSupportedException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException, InvalidTransactionException, NamingException {
		
    	//アクセスロック
    	AccessLock.lock(AccessLock.MONITOR_SNMPTRAP);

    	m_MibData = mibData;
		
		TransactionManager tm = null;
//		Transaction tx = null;
//		Transactionの利用を取りやめたため、関連箇所ふくめコメントアウトした : uchiyama		
		Transaction oldTx = null;
		boolean result = false;
		
		try 
		{
			// TransactionManagerを取得
			InitialContext context = new InitialContext();
			tm = (TransactionManager)context.lookup("java:/TransactionManager");
			
			// 実行中のスレッドがトランザクションに関連付けられている場合は、トランザクションを退避 
			if(tm.getTransaction() != null){
				oldTx = tm.suspend();
			}
			
			try{
				// トランザクション開始
				if(tm.getTransaction() == null){
					tm.begin();	
//					tx = tm.getTransaction();
				}
				
				// 監視情報を登録
				result = addMibMaster(user);
				if(result){
					// コミット
//					tx.commit();
					tm.commit();
				}
			
			} catch(NotSupportedException e){
				outputLog(e, "add()");
				throw e;
			} catch (RollbackException e) {
				outputLog(e, "add()");
				throw e;
			} catch (HeuristicMixedException e) {
				outputLog(e, "add()");
				throw e;
			} catch(HeuristicRollbackException e){
				outputLog(e, "add()");
				throw e;
			} catch(SystemException e){
				outputLog(e, "add()");
				throw e;
			}
			finally{
				// トランザクション関連の例外が発生した場合は、ロールバック
//				if(tx != null){
//					if(!result){
//						tx.rollback();
//					}
//					tx = null;
//				}
				if(tm.getTransaction() != null){
					if(!result){
						tm.rollback();
					}
				}
			}
		}
		finally{
			
			// 一時停止していたトランザクションを再開
			if(oldTx != null){
				try{
					tm.resume(oldTx);
				
				} catch(InvalidTransactionException e){
					outputLog(e, "add()");
					throw e;
				} catch(IllegalStateException e){
					outputLog(e, "add()");
					throw e;
				} catch(SystemException e){
					outputLog(e, "add()");
					throw e;
				}
			}
		}
		return result;
	}

	/**
	 * MIBマスターを登録します。<BR>
	 * 
	 * @param user ユーザ
	 * @return 登録に成功した場合、true
	 * @throws CreateException
	 * @throws NamingException
	 * @throws FinderException 
	 */
	public boolean addMibMaster(String user) throws CreateException, NamingException {
		boolean result = false;
		
		try 
		{
			Timestamp now = new Timestamp(new Date().getTime());
			
			
			// 監視情報を挿入
			SnmpTrapMibMasterUtil.getLocalHome().create(
					m_MibData.getMib(),
					m_MibData.getOrderNo(), 
					m_MibData.getDescription(), 
					now.getTime(), 
					now.getTime(),
					user, 
					user
			);
				
			result = true;
			
		} catch (CreateException e) {
			outputLog(e, "addMibMaster()");
			throw e;
		} catch (NamingException e) {
			outputLog(e, "addMibMaster()");
			throw e;
		} 
		return result;
	}
	
	/**
     * アプリケーションログにログを出力
     * 
     * @param e 例外
     */
	private void outputLog(Exception e, String method){
		AplLogger apllog = new AplLogger("TRAP", "trap");
		String[] args = {m_MibData.getMib()};
        apllog.put("SYS", "001", args);
        m_log.debug(method + ":" + e.getMessage());
	}
}
