/*
 
Copyright (C) 2010 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.selfcheck.jmx;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

import org.jboss.system.ServiceMBeanSupport;

import com.clustercontrol.selfcheck.SelfCheckConfig;
import com.clustercontrol.selfcheck.SelfCheckTaskSubmitter;

public class SelfCheckService extends ServiceMBeanSupport implements SelfCheckServiceMBean {
	
	private static volatile SelfCheckConfig config = new SelfCheckConfig();
	private static ScheduledExecutorService scheduler;
	private static SelfCheckTaskSubmitter submitter;
	
	/**
	 * SelfCheckServiceのコンストラクタ
	 */
	public SelfCheckService() {
		/** メイン処理 */
	}
	
	/**
	 * MBeanの初期化処理
	 */
	@Override
	public void createService() throws Exception {
		/** メイン処理 */
		if (log.isInfoEnabled()) log.info("creating SelfCheckService...");
		if (log.isInfoEnabled()) log.info("created SelfCheckService successfully.");
	}
	
	/**
	 * MBeanの開始処理
	 */
	@Override
	public void startService() throws Exception {
		/** メイン処理 */
		if (log.isInfoEnabled()) log.info("starting SelfCheckService... (interval = " + config.getIntervalSec() + " [sec], startupDelay = " + config.getStartupDelaySec() + " [sec])");
		
		if (log.isInfoEnabled())  log.info("intitializing scheduler...");
		scheduler = Executors.newSingleThreadScheduledExecutor(
			new ThreadFactory() {
				public Thread newThread(Runnable r) {
					return new Thread(r, "SelfCheckScheduler");
				}
			}
		);
		if (log.isInfoEnabled()) log.info("initialized scheduler successfully.");
		
		submitter = new SelfCheckTaskSubmitter();
		scheduler.scheduleWithFixedDelay(
				submitter, 
				config.getStartupDelaySec() * 1000, 
				config.getIntervalSec() * 1000, 
				TimeUnit.MILLISECONDS
		);
		if (log.isInfoEnabled()) log.info("started SelfCheckService successfully.");
	}
	
	/**
	 * MBeanの停止処理
	 */
	@Override
	public void stopService() throws Exception {
		/** メイン処理 */
		if (log.isInfoEnabled()) log.info("stopping SelfCheckService...");
		scheduler.shutdown();
		if (log.isInfoEnabled()) log.info("stopped SelfCheckService successfully.");
	}
	
	/**
	 * MBeanの削除処理
	 */
	@Override
	public void destroyService() throws Exception {
		/** メイン処理 */
		if (log.isInfoEnabled()) log.info("destroying SelfCheckService...");
		if (log.isInfoEnabled()) log.info("destroyed SelfCheckService successfully.");
	}
	
	public void restart() throws Exception {
		if (log.isInfoEnabled()) log.info("restarting SelfCheckService...");
		if (scheduler != null && ! scheduler.isShutdown()) {
			stopService();
		}
		startService();
		if (log.isInfoEnabled()) log.info("restarted SelfCheckService successfully.");
	}

	public int getAlertThreshold() {
		return config.getAlertThreshold();
	}

	public boolean getDatasourceMonitoring() {
		return config.getDatasourceMonitoring();
	}

	public boolean getFileSystemMonitoring() {
		return config.getFileSystemMonitoring();
	}

	public int getIntervalSec() {
		return config.getIntervalSec();
	}

	public boolean getJMSMonitoring() {
		return config.getJmsMonitoring();
	}

	public int getJMSMessageCountThreshold() {
		return config.getJmsMessageCountThreshold();
	}
	
	public boolean getJVMHeapMonitoring() {
		return config.getJvmHeapMonitoring();
	}

	public int getJVMHeapThresholdMByte() {
		return config.getJvmHeapThresholdMByte();
	}

	public String getJndiDBMSScheduler() {
		return config.getJndiDBMSScheduler();
	}

	public String getJndiDatasourceHinemos() {
		return config.getJndiDatasourceHinemos();
	}

	public String getJndiRAMScheduler() {
		return config.getJndiRAMScheduler();
	}

	public String getMountPointDatabase() {
		return config.getMountPointDatabase();
	}

	public String getMountPointLog() {
		return config.getMountPointLog();
	}

	public int getSchedulerDelayThresholdSec() {
		return config.getSchedulerDelayThresholdSec();
	}

	public boolean getSchedulerMonitoring() {
		return config.getSchedulerMonitoring();
	}

	public String getSnmpCommunity() {
		return config.getSnmpCommunity();
	}

	public int getSnmpPort() {
		return config.getSnmpPort();
	}

	public int getSnmpRetries() {
		return config.getSnmpRetries();
	}

	public int getSnmpTimeoutMSec() {
		return config.getSnmpTimeoutMSec();
	}

	public String getSnmpVersion() {
		return config.getSnmpVersion();
	}

	public int getStartupDelaySec() {
		return config.getStartupDelaySec();
	}

	public boolean getSwapOutMonitoring() {
		return config.getSwapOutMonitoring();
	}

	public boolean getSyslogForwardMonitoring() {
		return config.getSyslogForwardMonitoring();
	}

	public int getThreadPoolSize() {
		return config.getThreadPoolSize();
	}

	public String getTriggerGroupDBMS() {
		return config.getTriggerGroupDBMS();
	}

	public String getTriggerGroupRAM() {
		return config.getTriggerGroupRAM();
	}

	public String getTriggerNameDBMS() {
		return config.getTriggerNameDBMS();
	}

	public String getTriggerNameRAM() {
		return config.getTriggerNameRAM();
	}

	public void setAlertThreshold(int count) {
		config.setAlertThreshold(count);
	}

	public void setDatasourceMonitoring(boolean enable) {
		config.setDatasourceMonitoring(enable);
	}

	public void setFileSystemMonitoring(boolean enable) {
		config.setFileSystemMonitoring(enable);
	}

	public void setIntervalSec(int sec) {
		config.setIntervalSec(sec);
	}

	public void setJMSMonitoring(boolean enable) {
		config.setJmsMonitoring(enable);
	}

	public void setJMSMessageCountThreshold(int count) {
		config.setJmsMessageCountThreshold(count);
	}
	
	public void setJVMHeapMonitoring(boolean enable) {
		config.setJvmHeapMonitoring(enable);
	}

	public void setJVMHeapThresholdMByte(int mbyte) {
		config.setJvmHeapThresholdMByte(mbyte);
	}

	public void setJndiDBMSScheduler(String jndi) {
		config.setJndiDBMSScheduler(jndi);
	}

	public void setJndiDatasourceHinemos(String jndi) {
		config.setJndiDatasourceHinemos(jndi);
	}

	public void setJndiRAMScheduler(String jndi) {
		config.setJndiRAMScheduler(jndi);
	}

	public void setMountPointDatabase(String mountPoint) {
		config.setMountPointDatabase(mountPoint);
	}

	public void setMountPointLog(String mountPoint) {
		config.setMountPointLog(mountPoint);
	}

	public void setSchedulerDelayThresholdSec(int sec) {
		config.setSchedulerDelayThresholdSec(sec);
	}

	public void setSchedulerMonitoring(boolean enable) {
		config.setSchedulerMonitoring(enable);
	}

	public String getSnmpHost() {
		return config.getSnmpHost();
	}

	public void setSnmpHost(String host) {
		config.setSnmpHost(host);
	}
	
	public void setSnmpCommunity(String community) {
		config.setSnmpCommunity(community);
	}

	public void setSnmpPort(int port) {
		config.setSnmpPort(port);
	}

	public void setSnmpRetries(int count) {
		config.setSnmpRetries(count);
	}

	public void setSnmpTimeoutMSec(int msec) {
		config.setSnmpTimeoutMSec(msec);
	}

	public void setSnmpVersion(String version) {
		config.setSnmpVersion(version);
	}

	public void setStartupDelaySec(int sec) {
		config.setStartupDelaySec(sec);
	}

	public void setSwapOutMonitoring(boolean enable) {
		config.setSwapOutMonitoring(enable);
	}

	public void setSyslogForwardMonitoring(boolean enable) {
		config.setSyslogForwardMonitoring(enable);
	}

	public void setThreadPoolSize(int size) {
		config.setThreadPoolSize(size);
	}

	public void setTriggerGroupDBMS(String group) {
		config.setTriggerGroupDBMS(group);
	}

	public void setTriggerGroupRAM(String group) {
		config.setTriggerGroupRAM(group);
	}

	public void setTriggerNameDBMS(String name) {
		config.setTriggerNameDBMS(name);
	}

	public void setTriggerNameRAM(String name) {
		config.setTriggerNameRAM(name);
	}

	public boolean getEvent() {
		return config.getEvent();
	}

	public boolean getSyslog() {
		return config.getSyslog();
	}

	public String getSyslogFacility() {
		return config.getSyslogFacility();
	}

	public String[] getSyslogHost() {
		return config.getSyslogHost();
	}

	public int getSyslogPort() {
		return config.getSyslogPort();
	}

	public String getSyslogSeverity() {
		return config.getSyslogSeverity();
	}

	public void setEvent(boolean enable) {
		config.setEvent(enable);
	}

	public void setSyslog(boolean enable) {
		config.setSyslog(enable);
	}

	public void setSyslogFacility(String facility) {
		config.setSyslogFacility(facility);
	}

	public void setSyslogHost(String[] hosts) {
		config.setSyslogHost(hosts);
	}

	public void setSyslogPort(int port) {
		config.setSyslogPort(port);
	}

	public void setSyslogSeverity(String severity) {
		config.setSyslogSeverity(severity);
	}
	
	public String showStatus() {
		return config.getStatusString();
	}

	public int getFileSystemDBThresholdPer() {
		return config.getFileSystemDBThresholdPer();
	}

	public int getFileSystemLogThresholdPer() {
		return config.getFileSystemLogThresholdPer();
	}

	public void setFileSystemDBThresholdPer(int percent) {
		config.setFileSystemDBThresholdPer(percent);
	}

	public void setFileSystemLogThresholdPer(int percent) {
		config.setFileSystemLogThresholdPer(percent);
	}

	public String[] getMonitorQueue() {
		return config.getMonitorQueue();
	}

	public String[] getMonitorTopic() {
		return config.getMonitorTopic();
	}

	public void setMonitorQueue(String[] queues) {
		config.setMonitorQueue(queues);
	}

	public void setMonitorTopic(String[] topics) {
		config.setMonitorTopic(topics);
	}

	public String getJndiLogTableDS() {
		return config.getJndiLogTableDS();
	}

	public boolean getLogTableSizeMonitoring() {
		return config.getLogTableSizeMonitoring();
	}

	public String getTableNameCollectedResourceLog() {
		return config.getTableNameCollectedResourceLog();
	}

	public String getTableNameCollectedResourceLogDesc() {
		return config.getTableNameCollectedResourceLogDesc();
	}

	public String getTableNameCrunLog() {
		return config.getTableNameCrunLog();
	}

	public String getTableNameCrunLogDesc() {
		return config.getTableNameCrunLogDesc();
	}

	public String getTableNameEventLog() {
		return config.getTableNameEventLog();
	}

	public String getTableNameEventLogDesc() {
		return config.getTableNameEventLogDesc();
	}

	public String getTableNameJobLog() {
		return config.getTableNameJobLog();
	}

	public String getTableNameJobLogDesc() {
		return config.getTableNameJobLogDesc();
	}

	public long getThresholdCollectedResourceLog() {
		return config.getThresholdCollectedResourceLog();
	}

	public long getThresholdCrunLog() {
		return config.getThresholdCrunLog();
	}

	public long getThresholdEventLog() {
		return config.getThresholdEventLog();
	}

	public long getThresholdJobLog() {
		return config.getThresholdJobLog();
	}

	public int getThresholdTypeCollectedResourceLog() {
		return config.getThresholdTypeCollectedResourceLog();
	}

	public int getThresholdTypeCrunLog() {
		return config.getThresholdTypeCrunLog();
	}

	public int getThresholdTypeEventLog() {
		return config.getThresholdTypeEventLog();
	}

	public int getThresholdTypeJobLog() {
		return config.getThresholdTypeJobLog();
	}

	public void setJndiLogTableDS(String jndi) {
		config.setJndiLogTableDS(jndi);
	}

	public void setLogTableSizeMonitoring(boolean enable) {
		config.setLogTableSizeMonitoring(enable);
	}

	public void setTableNameCollectedResourceLog(String tableName) {
		config.setTableNameCollectedResourceLog(tableName);
	}

	public void setTableNameCollectedResourceLogDesc(String desc) {
		config.setTableNameCollectedResourceLogDesc(desc);
	}

	public void setTableNameCrunLog(String tableName) {
		config.setTableNameCrunLog(tableName);
	}

	public void setTableNameCrunLogDesc(String desc) {
		config.setTableNameCrunLogDesc(desc);
	}

	public void setTableNameEventLog(String tableName) {
		config.setTableNameEventLog(tableName);
	}

	public void setTableNameEventLogDesc(String desc) {
		config.setTableNameEventLogDesc(desc);
	}

	public void setTableNameJobLog(String tableName) {
		config.setTableNameJobLog(tableName);
	}

	public void setTableNameJobLogDesc(String desc) {
		config.setTableNameJobLogDesc(desc);
	}

	public void setThresholdCollectedResourceLog(long threshold) {
		config.setThresholdCollectedResourceLog(threshold);
	}

	public void setThresholdCrunLog(long threshold) {
		config.setThresholdCrunLog(threshold);
	}

	public void setThresholdEventLog(long threshold) {
		config.setThresholdEventLog(threshold);
	}

	public void setThresholdJobLog(long threshold) {
		config.setThresholdJobLog(threshold);
	}

	public void setThresholdTypeCollectedResourceLog(int type) {
		config.setThresholdTypeCollectedResourceLog(type);
	}

	public void setThresholdTypeCrunLog(int type) {
		config.setThresholdTypeCrunLog(type);
	}

	public void setThresholdTypeEventLog(int type) {
		config.setThresholdTypeEventLog(type);
	}

	public void setThresholdTypeJobLog(int type) {
		config.setThresholdTypeJobLog(type);
	}

	public String getLastMonitorDate() {
		return config.getLastMonitorDateString();
	}

	public void setLastMonitorDate(String date) throws Exception {
		config.setLastMonitorDateString(date);
	}

	public boolean getMail() {
		return config.getMail();
	}

	public String[] getSyslogForwardHost() {
		return config.getSyslogForwardHost();
	}

	public void setMail(boolean enable) {
		config.setMail(enable);
	}

	public void setSyslogForwardHost(String[] hosts) {
		config.setSyslogForwardHost(hosts);
	}

	public String[] getMailAddress() {
		return config.getMailAddress();
	}

	public void setMailAddress(String[] addresses) {
		config.setMailAddress(addresses);
	}

}

