/*
 
Copyright (C) 2009 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * SNMPでノードの情報を埋める際の定義情報のクラス<BR>
 *
 * @version 2.4.3
 * @since 2.4.3
 */
public class RepositoryCacheProperties {
	protected static Log m_log = LogFactory.getLog( RepositoryCacheProperties.class );
	
	public static final String FACILITY_IP_ADDRESS_KEY = "common.repository.cache.facility.ipaddress";
	public static final String FACILITY_NODE_NAME_KEY  = "common.repository.cache.facility.nodename";
	
	public static final String FACILITY_TREE_FIND_ALL_KEY = "common.repository.cache.facilitytree.findall";
	public static final String FACILITY_TREE_FACILITY_ID_KEY = "common.repository.cache.facilitytree.facilityid";

	public static final String DEVICE_FACILITYID_KEY = "common.repository.cache.device.facilityid";
	public static final String FILESYSTEM_FACILITYID_KEY = "common.repository.cache.filesystem.facilityid";
	
	private static Properties m_properties;

	public static synchronized void init(){
		if (m_properties != null) {
			// 既に初期化されているため何もしない（synchronizedされているブロックの中でチェック）
			return;
		}
		
		m_properties = new Properties();

		try {
//			String homedir = System.getProperty("jboss.server.home.dir");
//			String propertyFile = homedir + File.separator + "conf"
//			+ File.separator + "repository-cache.properties";
			
			String etcdir = System.getProperty("hinemos.manager.etc.dir");
			String propertyFile = etcdir + File.separator + "hinemos.properties";
			
			m_properties.load(new FileInputStream(propertyFile));
		} catch (Exception e) {
//			m_log.error(e.getMessage(), e);
		}
	}
	
	/**
	 * キーに対応する値を取得します。
	 */
	public static int getProperties(String key) {
		if (m_properties == null) {
			init();
		}
		
		// プロパティ値を整数で返す
		try{
			String property = m_properties.getProperty(key);
			
			if(property != null){
				return Integer.parseInt(property);
			}
		} catch (Exception e) {
			// 何もしない
		}
		// プロパティが正常に読めない場合、キャッシュは無効
		return 0;
	}
}
