/*
 
Copyright (C) since 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.ejb.entity;

import java.rmi.RemoteException;

import javax.ejb.EJBException;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

import com.clustercontrol.repository.ejb.entity.NodeLocal;

/**
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="NodeDevice" 
 *    jndi-name="NodeDevice"
 *    type="CMP" 
 *    view-type="local"
 *    schema="NodeDeviceSCHEMA" 
 *    cmp-version="2.x"
 *
 * @ejb.persistence 
 *    table-name="public.cc_cfg_node_device" 
 * 
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM NodeDeviceSCHEMA as a"  
 *    signature="java.util.Collection findAll()"  
 *
 * @ejb.pk class="com.clustercontrol.repository.ejb.entity.NodeDeviceBeanPK"
 * 
 * @ejb.permission
 *    unchecked="true"
 *
 * @jboss.depends
 *    name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 * 
 * @jboss.read-ahead
 *    strategy="on-load"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 * @jboss.persistence
 *    datasource="java:/HinemosDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_cfg_node_device"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 * <!-- end-xdoclet-definition -->
 * @generated
 **/

public abstract class NodeDeviceBean implements javax.ejb.EntityBean {

	/**
	 * Generated Primary Key Class
	 * @generated
	 */
	public class PrimaryKey {
		/**
		 * @generated
		 */
		public java.lang.String facilityId;
		/**
		 * @generated
		 */
		public java.lang.String deviceType;
		/**
		 * @generated
		 */
		public java.lang.Integer deviceIndex;
	}

	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public NodeDeviceBeanPK ejbCreate(java.lang.String facilityId, java.lang.String deviceType, int deviceIndex)
			throws javax.ejb.CreateException {
		// EJB 2.0 spec says return null for CMP ejbCreate methods.
		// TODO: YOU MUST INITIALIZE THE FIELDS FOR THE BEAN HERE. 
		// setMyField("Something"); 
		// begin-user-code
		setFacilityId(facilityId);
		setDeviceType(deviceType);
		setDeviceIndex(deviceIndex);
		setDeviceName("");
		setDeviceDisplayName("");
		setDeviceSnmpOid("");
		setDeviceDescription("");
		return null;
		// end-user-code
	}

	/**
	 * <!-- begin-user-doc -->
	 * The container invokes this method immediately after it calls ejbCreate.
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void ejbPostCreate() throws javax.ejb.CreateException {
		// begin-user-code
		// end-user-code
	}

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field facilityId
	 *
	 * Returns the facilityId
	 * @return the facilityId
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="facility_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getFacilityId();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the facilityId
	 * 
	 * @param java.lang.String the new facilityId value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setFacilityId(java.lang.String facilityId);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field deviceType
	 *
	 * Returns the deviceType
	 * @return the deviceType
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="device_type"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getDeviceType();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the deviceType
	 * 
	 * @param java.lang.String the new deviceType value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setDeviceType(java.lang.String deviceType);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field deviceIndex
	 *
	 * Returns the deviceIndex
	 * @return the deviceIndex
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="device_index"
	 *     jdbc-type="INTEGER"
	 *     sql-type="int4"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.Integer getDeviceIndex();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the deviceIndex
	 * 
	 * @param java.lang.Integer the new deviceIndex value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setDeviceIndex(java.lang.Integer deviceIndex);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field deviceName
	 *
	 * Returns the deviceName
	 * @return the deviceName
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="device_name"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(128)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getDeviceName();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the deviceName
	 * 
	 * @param java.lang.String the new deviceName value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setDeviceName(java.lang.String deviceName);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field deviceDisplayName
	 *
	 * Returns the deviceDisplayName
	 * @return the deviceDisplayName
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="device_display_name"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(128)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getDeviceDisplayName();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the deviceDisplayName
	 * 
	 * @param java.lang.String the new deviceDisplayName value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setDeviceDisplayName(java.lang.String deviceDisplayName);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field deviceSnmpOid
	 *
	 * Returns the deviceSnmpOid
	 * @return the deviceSnmpOid
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="device_snmp_oid"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(256)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getDeviceSnmpOid();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the deviceSnmpOid
	 * 
	 * @param java.lang.String the new deviceSnmpOid value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setDeviceSnmpOid(java.lang.String deviceSnmpOid);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field deviceDescription
	 *
	 * Returns the deviceDescription
	 * @return the deviceDescription
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="device_description"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(1024)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getDeviceDescription();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the deviceDescription
	 * 
	 * @param java.lang.String the new deviceDescription value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setDeviceDescription(java.lang.String deviceDescription);

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbActivate()
	 */
	public void ejbActivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbLoad()
	 */
	public void ejbLoad() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbPassivate()
	 */
	public void ejbPassivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbRemove()
	 */
	public void ejbRemove() throws RemoveException, EJBException,
			RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbStore()
	 */
	public void ejbStore() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#setEntityContext(javax.ejb.EntityContext)
	 */
	public void setEntityContext(EntityContext ctx) throws EJBException,
			RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#unsetEntityContext()
	 */
	public void unsetEntityContext() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/**
	 * 
	 */
	public NodeDeviceBean() {
		// TODO Auto-generated constructor stub
	}

	//==========================================
	// CMR fields
	//==========================================
	
	/**
	 * デバイスが対応するノードエンティティを取得します。<BR>
	 * 
	 * @return ノードエンティティ
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @ejb.relation
	 *    name="node-may-contain-device"
	 *    role-name="DeviceToNode"
	 *    cascade-delete="true"
	 * 
	 * @jboss.relation
	 *    related-pk-field="facilityId"
	 *    fk-column="facility_id"
	 *    batch-cascade-delete="true"
	 */
	public abstract NodeLocal getNode();
	
	/**
	 * ノードエンティティを格納します。<BR>
	 * 
	 * @param node ノードエンティティ
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 */
	public abstract void setNode(NodeLocal node);
}
