/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.repository.ejb.entity;

import javax.ejb.EntityBean;

/**
 * 値の型定義情報を管理するEntity Bean <BR>
 * 
 * @ejb.bean name="CollectorPlatformMst"
 *    jndi-name="CollectorPlatformMst"
 *    type="CMP"
 *    schema="CollectorPlatformMst" 
 *    cmp-version="2.x"
 *    data-source="java:/HinemosDS"
 *    primkey-field="platformId"
 *    view-type="local" 
 * 
 * @ejb.persistence 
 *    table-name="public.cc_collector_platform_mst"  
 * 
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM CollectorPlatformMst as a ORDER BY a.orderNo"  
 *    signature="java.util.Collection findAll()"
 * 
 * @ejb.pk class="java.lang.String"
 * 
 * @ejb.permission
 *    unchecked="true"
 * 
 * @jboss.depends
 *    name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 * 
 * @jboss.read-ahead
 *    strategy="on-load"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 * @jboss.persistence
 *    datasource="java:/HinemosDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_collector_platform_mst"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 */
public abstract class CollectorPlatformMstBean implements EntityBean {
	
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public java.lang.String ejbCreate(
			String platformId,
			String platformName,
			Short orderNo
			) throws javax.ejb.CreateException {
		
		this.setPlatformId(platformId);
		this.setPlatformName(platformName);
		this.setOrderNo(orderNo);
		return null;
	}
	
	/**
	 * コンストラクター
	 * @param platformId プラットフォーム種別
	 * @param platformName プラットフォーム名称
	 * @throws javax.ejb.CreateException
	 */
	public void ejbPostCreate(
			String platformId,
			String platformName,
			Short orderNo
			) throws javax.ejb.CreateException {
	}
	
	/**
	 * プラットフォーム種別を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="platform_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 * @ejb.pk-field 
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the platformId.
	 */
	public abstract String getPlatformId();

	/**
	 * プラットフォーム種別を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param platformId The platformId to set.
	 */
	public abstract void setPlatformId(String platformId);

	/**
	 * プラットフォーム名称を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="platform_name"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the platformName.
	 */
	public abstract String getPlatformName();

	/**
	 * プラットフォーム名称を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param platformName The platformName to set.
	 */
	public abstract void setPlatformName(String platformName);

	
	/**
	 * 表示順を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="order_no"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="SMALLINT"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the orderNo.
	 */
	public abstract String getOrderNo();

	/**
	 * 表示順を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param orderNo The orderNo to set.
	 */
	public abstract void setOrderNo(Short orderNo);
}
