/*
                                                                                                                                                                 
Copyright (C) 2008 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performance.operator;

/**
 * 100-(var0+var1)/(var2+var3)*100を求めます。
 */
public class InvPercentage22 extends Operator {
	@Override
	public double calc() throws CollectedDataNotFoundException, InvalidValueException{
		double totalNumerator; // 分子
		double totalDenominator; // 分母
		
		totalNumerator = getCurrentMibValue("var0") + getCurrentMibValue("var1");
		totalDenominator = getCurrentMibValue("var2") + getCurrentMibValue("var3");
		
		if(totalDenominator == 0){
			// エラー処理　おそらく値がとれていない
			return Double.NaN;
		}
		
		return 100.0D - totalNumerator / totalDenominator * 100.0D;
	}
}
