/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.notify.ejb.entity;

import java.rmi.RemoteException;

import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

/**
 * 通知ジョブ情報のCMP Entity Beanです。
 * 
 * @ejb.bean name="NotifyJobInfo"
 *     jndi-name="NotifyJobInfo"
 *     type="CMP"
 *     view-type = "local"
 *     schema="NotifyJobInfo"
 *     cmp-version="2.x"
 *     data-source="java:/HinemosDS"
 *       
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 *    
 * @jboss.persistence
 *    datasource="java:/HinemosDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_notify_job_info"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 *           
 * @ejb.persistence 
 *     table-name="cc_notify_job_info"
 *     
 * @ejb.finder 
 *     query="SELECT OBJECT(a) FROM NotifyJobInfo as a"  
 *     signature="java.util.Collection findAll()"
 *           
 * @ejb.permission
 *     unchecked="true"
 *     
 * @ejb.interface local-extends="javax.ejb.EJBLocalObject, com.clustercontrol.notify.ejb.entity.NotifyDetail"
 *     
 * @ejb.pk class="com.clustercontrol.notify.ejb.entity.NotifyJobInfoPK"
 */
public abstract class NotifyJobInfoBean implements EntityBean, NotifyDetail {
	
	/* (非 Javadoc)
	 * @see javax.ejb.EntityBean#setEntityContext(javax.ejb.EntityContext)
	 */
	public void setEntityContext(EntityContext ctx) throws EJBException, RemoteException {
	}
	
	/* (非 Javadoc)
	 * @see javax.ejb.EntityBean#unsetEntityContext()
	 */
	public void unsetEntityContext() throws EJBException, RemoteException {
	}
	
	/**
	 * 通知ジョブ情報を生成します。
	 *
	 * @ejb.create-method
	 * 
	 * @param notifyId 通知ID
	 * @param priority 重要度
	 * @param jobRun ジョブ実行
	 * @param jobunitId 所属ジョブユニットのジョブID
	 * @param jobId ジョブID
	 * @param jobFailurePriority ジョブ呼出失敗時の重要度
	 * @param jobExecFacilityFlg 実行ファシリティフラグ
	 * @param jobExecFacility  実行ファシリティ
	 * @return プライマリキー
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.bean.ValidConstant
	 * @see com.clustercontrol.bean.JobConfirmConstant
	 */
	public NotifyJobInfoPK ejbCreate(
			String notifyId,
			Integer priority,
			Integer jobRun,
			String jobunitId, 
			String jobId,
			Integer jobFailurePriority,
			Integer jobExecFacilityFlg,
			String jobExecFacility
			) throws javax.ejb.CreateException {
		
		setNotifyId(notifyId);
		setPriority(priority);
		setValidFlg(jobRun);
		setJobunitId(jobunitId);
		setJobId(jobId);
		setJobFailurePriority(jobFailurePriority);
		setJobExecFacilityFlg(jobExecFacilityFlg);
		setJobExecFacility(jobExecFacility);
		
		return null;
	}
	
	public void ejbRemove() throws RemoveException, EJBException, RemoteException {
	}
	
	public void ejbActivate() throws EJBException, RemoteException {
	}
	
	public void ejbPassivate() throws EJBException, RemoteException {
	}
	
	public void ejbLoad() throws EJBException, RemoteException {
	}
	
	public void ejbStore() throws EJBException, RemoteException {
	}
	
	/**
	 * 通知IDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="notify_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return 通知ID
	 */
	public abstract String getNotifyId();
	
	/**
	 * 通知IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param notifyId 通知ID
	 */
	public abstract void setNotifyId(String notifyId);
	
	/**
	 * 重要度を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="priority"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 * @ejb.pk-field 
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract Integer getPriority();
	
	/**
	 * 重要度を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param priority 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract void setPriority(Integer priority);
	
	/**
	 * ジョブ呼出失敗時の重要度を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="job_failure_priority"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return ジョブ呼出失敗時の重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract Integer getJobFailurePriority();

	/**
	 * ジョブ呼出失敗時の重要度を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param jobFailurePriority ジョブ呼出失敗時の重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract void setJobFailurePriority(Integer jobFailurePriority);
	
	/**
	 * 所属ジョブユニットのジョブIDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="jobunit_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 所属ジョブユニットのジョブID
	 */
	public abstract String getJobunitId();

	/**
	 * 所属ジョブユニットのジョブIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param jobunitId 所属ジョブユニットのジョブID
	 */
	public abstract void setJobunitId(String jobunitId);	
	
	/**
	 * ジョブIDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="job_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *
	 * @ejb.interface-method
	 * 
	 * @return ジョブID
	 */
	public abstract String getJobId();

	/**
	 * ジョブIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param jobId ジョブID
	 */
	public abstract void setJobId(String jobId);
	
	/**
	 * ジョブ実行を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="job_run"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return ジョブ実行
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract Integer getValidFlg();
	/**
	 * ジョブ実行を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param jobRun ジョブ実行
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract void setValidFlg(Integer commandFlg);
	
	
	/**
	 * ジョブを実行するファシリティのフラグを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="job_exec_facility_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return ジョブを実行するファシリティのフラグ
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract Integer getJobExecFacilityFlg();

	/**
	 * ジョブを実行するファシリティのフラグを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param jobExecFacilityFlg ジョブを実行するファシリティのフラグ
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract void setJobExecFacilityFlg(Integer jobExecFacilityFlg);
	
	/**
	 * ジョブを実行するファシリティを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="job_exec_facility"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *
	 * @ejb.interface-method
	 * 
	 * @return ジョブを実行するファシリティ
	 */
	public abstract String getJobExecFacility();

	/**
	 * ジョブを実行するファシリティを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param jobExecFacility ジョブを実行するファシリティ
	 */
	public abstract void setJobExecFacility(String jobExecFacility);
	
	/**
	 * このCMPのデータをフィールドとして持つDataオブジェクト（NotifyJobInfoData）を返します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns Dataオブジェクト（NotifyJobInfoData）
	 */
	public abstract NotifyJobInfoData getData();
	
	
	//	==========================================
	//	 CMR fields
	//	==========================================
	/**
	 * 通知情報を返します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @ejb.relation 
	 * name="NotifyInfo-NotifyJobInfo"
	 * role-name="NotifyJobInfo-NotifyInfo(multi)"
	 * cascade-delete="true"
	 * 
	 * @jboss.relation
	 * related-pk-field="notifyId"
	 * fk-column="notify_id"
	 * batch-cascade-delete="true"
	 * 
	 * @return 通知情報
	 */
	public abstract NotifyInfoLocal getNotifyInfo();
	
	/**
	 * 通知情報を設定します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @param notifyInfo 通知情報
	 */
	public abstract void setNotifyInfo(NotifyInfoLocal notifyInfo);
}
