/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.ejb.entity;

import java.util.Collection;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.JobInfoNotFoundException;
import com.clustercontrol.bean.OutputBasicInfo;
import com.clustercontrol.jobmanagement.dao.JobParamInfoDAOImpl;
import com.clustercontrol.notify.bean.NotifyRequestMessage;

/**
 * ジョブ変数情報のBMP Entity Bean クラス<BR>
 * 
 * @ejb.bean name="JobParamInfo"
 *    jndi-name="JobParamInfo"
 *    type="BMP"
 *    view-type="local"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Log BMP EntityBean"
 * 
 * @jboss.depends
 *    name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.dao
 *    class="com.clustercontrol.jobmanagement.dao.JobParamInfoDAO"
 *    impl-class="com.clustercontrol.jobmanagement.dao.JobParamInfoDAOImpl"
 * 
 * @ejb.permission
 *    unchecked="true"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 * @see com.clustercontrol.jobmanagement.dao.JobParamInfoDAO
 * @see com.clustercontrol.jobmanagement.dao.JobParamInfoDAOImpl
 */
public abstract class JobParamInfoBean implements javax.ejb.EntityBean {
	/** セッションID */
	protected String session_id;
	/** 所属ジョブユニットのジョブID */
	protected String jobunit_id;
	/** ジョブID */
	protected String job_id;
	/** パラメータID */
	protected String param_id;
	/** パラメータ種別 */
	protected Integer param_type;
	/** 説明 */
	protected String description;
	/** 値 */
	protected String value;
	
	/**
	 * ジョブ変数情報を生成します。
	 * 
	 * @ejb.create-method 
	 * 
	 * @param session_id セッションID
	 * @param jobunit_id 所属ジョブユニットのジョブID
	 * @param job_id ジョブID
	 * @param param_id パラメータID
	 * @param param_type パラメータ種別
	 * @param description 説明
	 * @param value 値
	 * @return プライマリーキー
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.bean.JobParamTypeConstant
	 */
	public JobParamInfoPK ejbCreate(
			String session_id,
			String jobunit_id, 
			String job_id, 
			String param_id, 
			Integer param_type, 
			String description, 
			String value
	) throws javax.ejb.CreateException {
		this.session_id = session_id;
		this.jobunit_id = jobunit_id;
		this.job_id = job_id;
		this.param_id = param_id;
		this.param_type = param_type;
		this.description = description;
		this.value = value;
		return null;
	}
	
	/**
	 * 全てのジョブ変数情報を検索します。
	 * 
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobParamInfoDAOImpl#findAll()
	 */
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	/**
	 * プライマリキーに一致するジョブ変数情報を検索します。
	 * 
	 * @param pk プライマリキー
	 * @return プライマリキー
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobParamInfoDAOImpl#findByPrimaryKey(JobParamInfoPK)
	 */
	public JobParamInfoPK ejbFindByPrimaryKey(JobParamInfoPK pk) throws FinderException {
		return null;
	}
	
	/**
	 * セッションIDに一致するジョブ変数情報を検索します。
	 * 
	 * @param session_id セッションID
	 * @param job_id ジョブID
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobParamInfoDAOImpl#findBySessionIdAndJobId(String, String)
	 */
	public Collection ejbFindBySessionId(String session_id) throws FinderException {
		return null;
	}
	
	/**
	 * セッションIDとジョブIDに一致するジョブ変数情報を検索します。
	 * 
	 * @param session_id セッションID
	 * @param job_id ジョブID
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobParamInfoDAOImpl#findBySessionIdAndJobId(String, String)
	 */
	public Collection ejbFindBySessionIdAndJobId(String session_id, String job_id) throws FinderException {
		return null;
	}
	
	/**
	 * セッションIDとパラメータIDに一致するジョブ変数情報を検索します。
	 * 
	 * @param session_id セッションID
	 * @param param_id パラメータID
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobParamInfoDAOImpl#findBySessionIdAndParamId(String, String)
	 */
	public Collection ejbFindBySessionIdAndParamId(String session_id, String param_id) throws FinderException {
		return null;
	}
	
	/**
	 * セッションIDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return セッションID
	 */
	public java.lang.String getSession_id() {
		return session_id;
	}
	
	/**
	 * セッションIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param session_id セッションID
	 */
	public void setSession_id(java.lang.String session_id) {
		this.session_id = session_id;
	}
	
	/**
	 * 所属ジョブユニットのジョブIDを返す。<BR>
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return 所属ジョブユニットのジョブID
	 */
	public java.lang.String getJobunit_id() {
		return jobunit_id;
	}
	
	/**
	 * 所属ジョブユニットのジョブIDを設定する。<BR>
	 * 
	 * @ejb.interface-method
	 * 
	 * @param jobunit_id 所属ジョブユニットのジョブID
	 */
	public void setJobunit_id(java.lang.String jobunit_id) {
		this.jobunit_id = jobunit_id;
	}
	
	/**
	 * ジョブIDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return ジョブID
	 */
	public java.lang.String getJob_id() {
		return job_id;
	}
	
	/**
	 * ジョブIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param job_id ジョブID
	 */
	public void setJob_id(java.lang.String job_id) {
		this.job_id = job_id;
	}
	
	/**
	 * パラメータIDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return パラメータID
	 */
	public java.lang.String getParam_id() {
		return param_id;
	}
	
	/**
	 * パラメータIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param param_id パラメータID
	 */
	public void setParam_id(java.lang.String param_id) {
		this.param_id = param_id;
	}
	
	/**
	 * パラメータ種別を返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return パラメータ種別
	 * 
	 * @see com.clustercontrol.bean.JobParamTypeConstant
	 */
	public java.lang.Integer getParam_type() {
		return param_type;
	}
	
	/**
	 * パラメータ種別を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param param_type パラメータ種別
	 * 
	 * @see com.clustercontrol.bean.JobParamTypeConstant
	 */
	public void setParam_type(java.lang.Integer param_type) {
		this.param_type = param_type;
	}
	
	/**
	 * 説明を返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return 説明
	 */
	public java.lang.String getDescription() {
		return description;
	}
	
	/**
	 * 説明を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param description 説明
	 */
	public void setDescription(java.lang.String description) {
		this.description = description;
	}
	
	/**
	 * 値を返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return 値
	 */
	public java.lang.String getValue() {
		return value;
	}
	
	/**
	 * 値を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param value 値
	 */
	public void setValue(java.lang.String value) {
		this.value = value;
	}
	
	/**
	 * ジョブ情報を取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return ジョブ情報
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobInfoUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobInfoPK
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobInfoBean#ejbFindByPrimaryKey(JobInfoPK)
	 */
	public JobInfoLocal getJobInfo() {
		JobInfoLocal jobInfo = null;
		try {
			jobInfo = JobInfoUtil.getLocalHome().findByPrimaryKey(new JobInfoPK(getSession_id(), getJobunit_id(), getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobInfo;
	}
	
	/**
	 * 履歴情報を作成する。<BR>
	 * ジョブ変数情報をジョブ変数マスタから作成します。
	 * 
	 * @ejb.home-method view-type="both"
	 * 
     * @param sessionId セッションID
     * @param jobunitId 所属ジョブユニットのジョブID
     * @param jobId ジョブID
     * @param info ログ出力情報
     * @throws javax.ejb.CreateException
     * @throws NamingException
	 * @throws JobInfoNotFoundException 
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobParamInfoDAOImpl#makeSession(String, String, String, NotifyRequestMessage)
	 */
    public void ejbHomeMakeSession(String sessionId, String jobunitId, String jobId, OutputBasicInfo info) throws javax.ejb.CreateException, NamingException, JobInfoNotFoundException{
    	JobParamInfoDAOImpl jciDAO = new JobParamInfoDAOImpl(); 
    	
    	jciDAO.makeSession(sessionId, jobunitId, jobId, info);
    }
	
}
