/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.jobmanagement.ejb.entity;

import java.util.Collection;
import java.util.Date;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.jobmanagement.dao.JobInfoDAOImpl;

/**
 * ジョブ情報のBMP Entity Bean クラス<BR>
 * 
 * @ejb.bean name="JobInfo"
 *    jndi-name="JobInfo"
 *    type="BMP"
 *    view-type="local"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Log BMP EntityBean"
 * 
 * @jboss.depends
 *    name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.dao
 *    class="com.clustercontrol.jobmanagement.dao.JobInfoDAO"
 *    impl-class="com.clustercontrol.jobmanagement.dao.JobInfoDAOImpl"
 * 
 * @ejb.permission
 *    unchecked="true"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 * @see com.clustercontrol.jobmanagement.dao.JobInfoDAO
 * @see com.clustercontrol.jobmanagement.dao.JobInfoDAOImpl
 */
public abstract class JobInfoBean implements javax.ejb.EntityBean {
	/** セッションID */
	protected String session_id;
	/** 所属ジョブユニットのジョブID */
	protected String jobunit_id;
	/** ジョブID */
	protected String job_id;
	/** ジョブ名 */
	protected String job_name;
	/** 設定 */
	protected String description;
	/** ジョブ種別 */
	protected Integer job_type;
	/** 作成日時 */
	protected Date reg_date;
	/** 最終更新日時 */
	protected Date update_date;
	/** 新規作成ユーザ */
	protected String reg_user;
	/** 最終更新日時 */
	protected String update_user;
	
	/**
	 * ジョブ情報を生成します。
	 * 
	 * @ejb.create-method 
	 * 
	 * @param session_id セッションID
	 * @param jobunit_id 所属ジョブユニットのジョブID
	 * @param job_id ジョブID
	 * @param job_name ジョブ名
	 * @param description 説明
	 * @param job_type ジョブ種別
	 * @param reg_date 作成日時
	 * @param update_date 最終更新日時
	 * @param reg_user 新規作成ユーザ
	 * @param update_user 最終更新ユーザ
	 * @return プライマリーキー
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.bean.JobConstant
	 */
	public JobInfoPK ejbCreate(
			String session_id,
			String jobunit_id, 
			String job_id, 
			String job_name, 
			String description, 
			Integer job_type, 
			Date reg_date, 
			Date update_date, 
			String reg_user, 
			String update_user
	) throws javax.ejb.CreateException {
		this.session_id = session_id;
		this.jobunit_id = jobunit_id;
		this.job_id = job_id;
		this.job_name = job_name;
		this.description = description;
		this.job_type = job_type;
		this.reg_date = reg_date;
		this.update_date = update_date;
		this.reg_user = reg_user;
		this.update_user = update_user;
		return null;
	}

	/**
	 * 全てのジョブ情報を検索します。
	 * 
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobInfoDAOImpl#findAll()
	 */
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	/**
	 * プライマリキーに一致するジョブ情報を検索します。
	 * 
	 * @param pk プライマリキー
	 * @return プライマリキー
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobInfoDAOImpl#findByPrimaryKey(JobInfoPK)
	 */
	public JobInfoPK ejbFindByPrimaryKey(JobInfoPK pk) throws FinderException {
		return null;
	}
	
	/**
	 * セッションIDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return セッションID
	 */
	public java.lang.String getSession_id() {
		return session_id;
	}
	
	/**
	 * セッションIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param session_id セッションID
	 */
	public void setSession_id(java.lang.String session_id) {
		this.session_id = session_id;
	}
	
	/**
	 * 所属ジョブユニットのジョブIDを返す。<BR>
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return 所属ジョブユニットのジョブID
	 */
	public java.lang.String getJobunit_id() {
		return jobunit_id;
	}
	
	/**
	 * 所属ジョブユニットのジョブIDを設定する。<BR>
	 * 
	 * @ejb.interface-method
	 * 
	 * @param jobunit_id 所属ジョブユニットのジョブID
	 */
	public void setJobunit_id(java.lang.String jobunit_id) {
		this.jobunit_id = jobunit_id;
	}
	
	/**
	 * ジョブIDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return ジョブID
	 */
	public java.lang.String getJob_id() {
		return job_id;
	}
	
	/**
	 * ジョブIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param job_id ジョブID
	 */
	public void setJob_id(java.lang.String job_id) {
		this.job_id = job_id;
	}
	
	/**
	 * ジョブ名を返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return ジョブ名
	 */
	public java.lang.String getJob_name() {
		return job_name;
	}
	
	/**
	 * ジョブ名を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param job_name ジョブ名
	 */
	public void setJob_name(java.lang.String job_name) {
		this.job_name = job_name;
	}
	
	/**
	 * 説明を返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return 説明
	 */
	public java.lang.String getDescription() {
		return description;
	}
	
	/**
	 * 説明を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param description 説明
	 */
	public void setDescription(java.lang.String description) {
		this.description = description;
	}
	
	/**
	 * ジョブ種別を返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return ジョブ種別
	 * 
	 * @see com.clustercontrol.bean.JobConstant
	 */
	public java.lang.Integer getJob_type() {
		return job_type;
	}
	
	/**
	 * ジョブ種別を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param job_type ジョブ種別
	 * 
	 * @see com.clustercontrol.bean.JobConstant
	 */
	public void setJob_type(java.lang.Integer job_type) {
		this.job_type = job_type;
	}
	
	/**
	 * 作成日時を返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return 作成日時
	 */
	public java.util.Date getReg_date() {
		return reg_date;
	}
	
	/**
	 * 作成日時を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param reg_date 作成日時
	 */
	public void setReg_date(java.util.Date reg_date) {
		this.reg_date = reg_date;
	}
	
	/**
	 * 最終更新日時を返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return 最終更新日時
	 */
	public java.util.Date getUpdate_date() {
		return update_date;
	}
	
	/**
	 * 最終更新日時を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param update_date 最終更新日時
	 */
	public void setUpdate_date(java.util.Date update_date) {
		this.update_date = update_date;
	}
	
	/**
	 * 新規作成ユーザを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return 新規作成ユーザ
	 */
	public java.lang.String getReg_user() {
		return reg_user;
	}
	
	/**
	 * 新規作成ユーザを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param reg_user 新規作成ユーザ
	 */
	public void setReg_user(java.lang.String reg_user) {
		this.reg_user = reg_user;
	}
	
	/**
	 * 最終更新ユーザを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return 最終更新ユーザ
	 */
	public java.lang.String getUpdate_user() {
		return update_user;
	}
	
	/**
	 * 最終更新ユーザを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param update_user 最終更新ユーザ
	 */
	public void setUpdate_user(java.lang.String update_user) {
		this.update_user = update_user;
	}
	
	/**
	 * ジョブコマンド情報を取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return ジョブコマンド情報
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoPK
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoBean#ejbFindByPrimaryKey(JobCommandInfoPK)
	 */
	public JobCommandInfoLocal getJobCommandInfo() {
		JobCommandInfoLocal jobCommandInfo = null;
		try {
			jobCommandInfo = JobCommandInfoUtil.getLocalHome().findByPrimaryKey(new JobCommandInfoPK(getSession_id(), getJobunit_id(), getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobCommandInfo;
	}
	
	/**
	 * ジョブ終了状態情報を取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return ジョブ終了状態情報のコレクション
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobEndInfoUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobEndInfoBean#ejbFindBySessionIdAndJobId(String, String)
	 */
	public Collection getJobEndInfo() {
		Collection collection = null;
		try {
			collection = JobEndInfoUtil.getLocalHome().findBySessionIdAndJobId(getSession_id(), getJob_id());
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return collection;
	}
	
	/**
	 * ジョブ通知情報を取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return ジョブ通知情報のコレクション
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobNoticeInfoUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobNoticeInfoBean#ejbFindBySessionIdAndJobId(String, String)
	 */
	public Collection getJobNoticeInfo() {
		Collection collection = null;
		try {
			collection = JobNoticeInfoUtil.getLocalHome().findBySessionIdAndJobId(getSession_id(), getJob_id());
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return collection;
	}
	
	/**
	 * ジョブ待ち条件情報を取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return ジョブ待ち条件情報
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoPK
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoBean#ejbFindByPrimaryKey(JobStartInfoPK)
	 */
	public JobStartInfoLocal getJobStartInfo() {
		JobStartInfoLocal jobStartInfo = null;
		try {
			jobStartInfo = JobStartInfoUtil.getLocalHome().findByPrimaryKey(new JobStartInfoPK(getSession_id(), getJobunit_id(), getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobStartInfo;
	}
	
	/**
	 * セッションジョブを取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return セッションジョブ
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobPK
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobBean#ejbFindByPrimaryKey(JobSessionJobPK)
	 */
	public JobSessionJobLocal getJobSessionJob() {
		JobSessionJobLocal jobSessionJob = null;
		try {
			jobSessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(getSession_id(), getJobunit_id(), getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobSessionJob;
	}
	
	/**
	 * ジョブファイル転送情報を取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return ジョブファイル転送情報
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobFileInfoUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobFileInfoPK
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobFileInfoBean#ejbFindByPrimaryKey(JobFileInfoPK)
	 */
	public JobFileInfoLocal getJobFileInfo() {
		JobFileInfoLocal jobFileInfo = null;
		try {
			jobFileInfo = JobFileInfoUtil.getLocalHome().findByPrimaryKey(new JobFileInfoPK(getSession_id(), getJobunit_id(), getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobFileInfo;
	}
	
	/**
	 * ジョブ変数情報を取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return ジョブ変数情報のコレクション
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobParamInfoUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobParamInfoBean#ejbFindBySessionIdAndJobId(String, String)
	 */
	public Collection getJobParamInfo() {
		Collection collection = null;
		try {
			collection = JobParamInfoUtil.getLocalHome().findBySessionIdAndJobId(getSession_id(), getJob_id());
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return collection;
	}
	
	/**
	 * 履歴情報を作成する。<BR>
	 * ジョブ情報をジョブマスタから作成します。
	 * 
	 * @ejb.home-method view-type="both"
	 * 
	 * @param sessionId セッションID
	 * @param jobunitId 所属ジョブユニットのジョブID
	 * @param jobs ジョブIDのコレクション
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobInfoDAOImpl#makeSession(String, String, Collection)
	 */
    public void ejbHomeMakeSession(String sessionId, String jobunitId, Collection jobs) throws javax.ejb.CreateException{
    	JobInfoDAOImpl jiDAO = new JobInfoDAOImpl(); 
    	
    	jiDAO.makeSession(sessionId, jobunitId, jobs);
    }
	
}
