/*
 
Copyright (C) since 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.commons.util;

import java.util.ArrayList;
import java.util.Date;

/**
 * Java標準の基本クラスに対する値の妥当性確認あるいは変換処理を実装したクラス<BR>
 */
public class ObjectValidator {
	
	/**
	 * オブジェクトを文字列に変換する。<BR>
	 * Stringインスタンスの場合は与えられたオブジェクトを返し、そうでない場合は空文字のStringインスタンスを返す。<BR>
	 * 
	 * @param obj オブジェクト
	 * @return 与えられたStringインスタンスあるいは空文字列
	 */
	public static String objectToString(Object obj) {
		/** メイン処理 */
		if (obj instanceof String) {
			return (String)obj;
		} else {
			return "";
		}
	}
	
	/**
	 * オブジェクトがnullあるいは空文字列であるかどうかを確認する。<BR>
	 * 
	 * @param obj オブジェクト
	 * @return trueあるいはfalse
	 */
	public static boolean isEmptyString(Object obj) {
		/** メイン処理 */
		if (obj == null) {
			return true;
		} else if (obj instanceof String && ((String)obj).length() == 0) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	 * オブジェクトを文字列の配列に変換します。<BR>
	 * ArrayList<String>インスタンスの場合は与えられたオブジェクトを返し、そうでない場合は空のArrayList<String>インスタンスを返します。<BR>
	 * 
	 * @param obj オブジェクト
	 * @return
	 */
	public static ArrayList<String> objectToArrayListString(Object obj) {
		/** ローカル変数 */
		Object element = null;
		
		/** メイン処理 */
		if (obj instanceof ArrayList) {
			for (int i = 0; i < ((ArrayList<Object>)obj).size(); i++) {
				element = ((ArrayList<Object>)obj).get(i);
				if (element instanceof String) {
					if (isEmptyString(element)) {
						((ArrayList<Object>)obj).set(i, "");
					}
				} else {
					return new ArrayList<String>();
				}
			}
			return (ArrayList<String>)obj;
		} else {
			return new ArrayList<String>();
		}
	}
	
	/**
	 * オブジェクトをIntegerクラスに変換します。<BR>
	 * Integerインスタンスの場合は与えられたオブジェクトを返し、そうでない場合は-1のIntegerインスタンスを返します。<BR>
	 * 
	 * @param value オブジェクト
	 * @return 与えられたIntegerインスタンスあるいはnull
	 */
	public static Integer objectToInteger(Object obj) {
		if (obj instanceof Integer) {
			return (Integer)obj;
		} else {
			return new Integer(-1);
		}
	}
	
	/**
	 * オブジェクトをBooleanクラスに変換します。<BR>
	 * Booleanインスタンスの場合は与えられたオブジェクトを返し、そうでない場合はnullを返します。<BR>
	 * 
	 * @param value オブジェクト
	 * @return 与えられたIntegerインスタンスあるいはnull
	 */
	public static Boolean objectToBoolean(Object obj) {
		if (obj instanceof Boolean) {
			return (Boolean)obj;
		} else {
			return null;
		}
	}
	
	/**
	 * オブジェクトをDateクラスに変換します。<BR>
	 * Dateインスタンスの場合は与えられたオブジェクトを返し、そうでない場合はエポック秒が0であるDateインスタンスを返します。<BR>
	 * 
	 * @param value オブジェクト
	 * @return 与えられたIntegerインスタンスあるいはnull
	 */
	public static Date objectToDate(Object obj) {
		if (obj instanceof Date) {
			return (Date)obj;
		} else {
			return new Date(0);
		}
	}
}
