/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.security.SecurityAssociation;

class SubjectActions {
    SubjectActions() {
    }

    static Subject getActiveSubject() {
        Subject subject = (Subject)AccessController.doPrivileged(GetSubjectAction.ACTION);
        return subject;
    }

    static void copySubject(Subject fromSubject, Subject toSubject) {
        SubjectActions.copySubject(fromSubject, toSubject, false);
    }

    static void copySubject(Subject fromSubject, Subject toSubject, boolean setReadOnly) {
        CopySubjectAction action = new CopySubjectAction(fromSubject, toSubject, setReadOnly);
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(action);
        } else {
            action.run();
        }
    }

    static void copySubject(Subject fromSubject, Subject toSubject, boolean setReadOnly, boolean deepCopy) {
        CopySubjectAction action = new CopySubjectAction(fromSubject, toSubject, setReadOnly);
        action.setDeepCopy(deepCopy);
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(action);
        } else {
            action.run();
        }
    }

    static LoginContext createLoginContext(String securityDomain, Subject subject, CallbackHandler handler) throws LoginException {
        LoginContextAction action = new LoginContextAction(securityDomain, subject, handler);
        try {
            LoginContext lc = (LoginContext)AccessController.doPrivileged(action);
            return lc;
        }
        catch (PrivilegedActionException e) {
            Exception ex = e.getException();
            if (ex instanceof LoginException) {
                throw (LoginException)ex;
            }
            throw new LoginException(ex.getMessage());
        }
    }

    static ClassLoader getContextClassLoader() {
        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(GetTCLAction.ACTION);
        return loader;
    }

    static Object setContextInfo(Object key, Object value) {
        SetContextInfoAction action = new SetContextInfoAction(key, value);
        Object prevInfo = AccessController.doPrivileged(action);
        return prevInfo;
    }

    static void pushSubjectContext(Principal principal, Object credential, Subject subject) {
        if (System.getSecurityManager() == null) {
            PrincipalInfoAction.NON_PRIVILEGED.push(principal, credential, subject);
        } else {
            PrincipalInfoAction.PRIVILEGED.push(principal, credential, subject);
        }
    }

    static void popSubjectContext() {
        if (System.getSecurityManager() == null) {
            PrincipalInfoAction.NON_PRIVILEGED.pop();
        } else {
            PrincipalInfoAction.PRIVILEGED.pop();
        }
    }

    static String toString(Subject subject) {
        ToStringSubjectAction action = new ToStringSubjectAction(subject);
        String info = (String)AccessController.doPrivileged(action);
        return info;
    }

    static interface PrincipalInfoAction {
        public static final PrincipalInfoAction PRIVILEGED = new PrincipalInfoAction(){

            public void push(final Principal principal, final Object credential, final Subject subject) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        SecurityAssociation.pushSubjectContext(subject, principal, credential);
                        return null;
                    }
                });
            }

            public void pop() {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        SecurityAssociation.popSubjectContext();
                        return null;
                    }
                });
            }
        };
        public static final PrincipalInfoAction NON_PRIVILEGED = new PrincipalInfoAction(){

            public void push(Principal principal, Object credential, Subject subject) {
                SecurityAssociation.pushSubjectContext(subject, principal, credential);
            }

            public void pop() {
                SecurityAssociation.popSubjectContext();
            }
        };

        public void push(Principal var1, Object var2, Subject var3);

        public void pop();
    }

    private static class SetContextInfoAction
    implements PrivilegedAction {
        Object key;
        Object value;

        SetContextInfoAction(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object run() {
            return SecurityAssociation.setContextInfo(this.key, this.value);
        }
    }

    private static class GetTCLAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetTCLAction();

        private GetTCLAction() {
        }

        public Object run() {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return loader;
        }
    }

    private static class LoginContextAction
    implements PrivilegedExceptionAction {
        String securityDomain;
        Subject subject;
        CallbackHandler handler;

        LoginContextAction(String securityDomain, Subject subject, CallbackHandler handler) {
            this.securityDomain = securityDomain;
            this.subject = subject;
            this.handler = handler;
        }

        public Object run() throws Exception {
            LoginContext lc = new LoginContext(this.securityDomain, this.subject, this.handler);
            return lc;
        }
    }

    private static class CopySubjectAction
    implements PrivilegedAction {
        Subject fromSubject;
        Subject toSubject;
        boolean setReadOnly;
        boolean deepCopy;

        CopySubjectAction(Subject fromSubject, Subject toSubject, boolean setReadOnly) {
            this.fromSubject = fromSubject;
            this.toSubject = toSubject;
            this.setReadOnly = setReadOnly;
        }

        public void setDeepCopy(boolean flag) {
            this.deepCopy = flag;
        }

        public Object run() {
            Set<Principal> principals = this.fromSubject.getPrincipals();
            Set<Principal> principals2 = this.toSubject.getPrincipals();
            Iterator<Object> iter = principals.iterator();
            while (iter.hasNext()) {
                principals2.add((Principal)this.getCloneIfNeeded(iter.next()));
            }
            Set<Object> privateCreds = this.fromSubject.getPrivateCredentials();
            Set<Object> privateCreds2 = this.toSubject.getPrivateCredentials();
            iter = privateCreds.iterator();
            while (iter.hasNext()) {
                privateCreds2.add(this.getCloneIfNeeded(iter.next()));
            }
            Set<Object> publicCreds = this.fromSubject.getPublicCredentials();
            Set<Object> publicCreds2 = this.toSubject.getPublicCredentials();
            iter = publicCreds.iterator();
            while (iter.hasNext()) {
                publicCreds2.add(this.getCloneIfNeeded(iter.next()));
            }
            if (this.setReadOnly) {
                this.toSubject.setReadOnly();
            }
            return null;
        }

        private Object getCloneIfNeeded(Object obj) {
            Object clonedObject = null;
            if (this.deepCopy && obj instanceof Cloneable) {
                Class<?> clazz = obj.getClass();
                try {
                    Method cloneMethod = clazz.getMethod("clone", null);
                    clonedObject = cloneMethod.invoke(obj, null);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (clonedObject == null) {
                clonedObject = obj;
            }
            return clonedObject;
        }
    }

    private static class GetSubjectAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetSubjectAction();

        private GetSubjectAction() {
        }

        public Object run() {
            Subject subject = SecurityAssociation.getSubject();
            return subject;
        }
    }

    private static class ToStringSubjectAction
    implements PrivilegedAction {
        Subject subject;

        ToStringSubjectAction(Subject subject) {
            this.subject = subject;
        }

        public Object run() {
            StringBuffer tmp = new StringBuffer();
            tmp.append("Subject(");
            tmp.append(System.identityHashCode(this.subject));
            tmp.append(").principals=");
            for (Principal p : this.subject.getPrincipals()) {
                Class<?> c = p.getClass();
                tmp.append(c.getName());
                tmp.append('@');
                tmp.append(System.identityHashCode(c));
                tmp.append('(');
                tmp.append(p);
                tmp.append(')');
            }
            return tmp.toString();
        }
    }
}

