/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.http.interfaces;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationException;
import org.jboss.invocation.MarshalledValue;
import org.jboss.invocation.http.interfaces.AnyhostVerifier;
import org.jboss.logging.Logger;
import org.jboss.net.ssl.SSLSocketFactoryBuilder;
import org.jboss.security.SecurityAssociationAuthenticator;

public class Util {
    public static final String IGNORE_HTTPS_HOST = "org.jboss.security.ignoreHttpsHost";
    public static final String SSL_FACTORY_BUILDER = "org.jboss.security.httpInvoker.sslSocketFactoryBuilder";
    private static String REQUEST_CONTENT_TYPE = "application/x-java-serialized-object; class=org.jboss.invocation.MarshalledInvocation";
    private static Logger log = Logger.getLogger(Util.class);
    private static SSLSocketFactoryBuilder sslSocketFactoryBuilder;

    public static void init() {
        try {
            SetAuthenticator action = new SetAuthenticator();
            AccessController.doPrivileged(action);
        }
        catch (Exception e) {
            log.warn((Object)"Failed to install SecurityAssociationAuthenticator", (Throwable)e);
        }
    }

    public static Object invoke(URL externalURL, Invocation mi) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)("invoke, externalURL=" + externalURL));
        }
        HttpURLConnection conn = (HttpURLConnection)externalURL.openConnection();
        Util.configureHttpsHostVerifier(conn);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("ContentType", REQUEST_CONTENT_TYPE);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Accept-Encoding", "x-gzip,x-deflate,gzip,deflate");
        OutputStream os = conn.getOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(os);
        try {
            oos.writeObject(mi);
            oos.flush();
        }
        catch (ObjectStreamException e) {
            throw new InvocationException(e);
        }
        InputStream is = conn.getInputStream();
        String encoding = conn.getHeaderField("Content-Encoding");
        if (encoding != null && encoding.indexOf("gzip") >= 0) {
            is = new GZIPInputStream(is);
        }
        ObjectInputStream ois = new ObjectInputStream(is);
        MarshalledValue mv = (MarshalledValue)ois.readObject();
        ois.read();
        ois.close();
        oos.close();
        Object value = mv.get();
        if (value instanceof Exception) {
            throw (Exception)value;
        }
        return value;
    }

    public static void configureHttpsHostVerifier(HttpURLConnection conn) {
        if (conn instanceof HttpsURLConnection && Boolean.getBoolean(IGNORE_HTTPS_HOST)) {
            AnyhostVerifier.setHostnameVerifier(conn);
        }
    }

    public static void configureSSLSocketFactory(HttpURLConnection conn) throws InvocationTargetException {
        Class<?> connClass = conn.getClass();
        if (conn instanceof HttpsURLConnection && sslSocketFactoryBuilder != null) {
            try {
                SSLSocketFactory socketFactory = sslSocketFactoryBuilder.getSocketFactory();
                Class[] sig = new Class[]{SSLSocketFactory.class};
                Method method = connClass.getMethod("setSSLSocketFactory", sig);
                Object[] args = new Object[]{socketFactory};
                method.invoke((Object)conn, args);
                log.trace((Object)"Socket factory set on connection");
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
    }

    public static URL resolveURL(String urlValue) throws MalformedURLException {
        if (urlValue == null) {
            return null;
        }
        URL externalURL = null;
        try {
            externalURL = new URL(urlValue);
        }
        catch (MalformedURLException e) {
            String urlProperty = System.getProperty(urlValue);
            if (urlProperty == null) {
                throw e;
            }
            externalURL = new URL(urlProperty);
        }
        return externalURL;
    }

    static {
        try {
            SetAuthenticator action = new SetAuthenticator();
            AccessController.doPrivileged(action);
        }
        catch (Exception e) {
            log.warn((Object)"Failed to install SecurityAssociationAuthenticator", (Throwable)e);
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String factoryFactoryFQCN = null;
        try {
            ReadSSLBuilder action = new ReadSSLBuilder();
            factoryFactoryFQCN = (String)AccessController.doPrivileged(action);
        }
        catch (Exception e) {
            log.warn((Object)"Failed to read org.jboss.security.httpInvoker.sslSocketFactoryBuilder", (Throwable)e);
        }
        if (factoryFactoryFQCN != null) {
            try {
                Class<?> clazz = loader.loadClass(factoryFactoryFQCN);
                sslSocketFactoryBuilder = (SSLSocketFactoryBuilder)clazz.newInstance();
            }
            catch (Exception e) {
                log.warn((Object)"Could not instantiate SSLSocketFactoryFactory", (Throwable)e);
            }
        }
    }

    static class ReadSSLBuilder
    implements PrivilegedAction {
        ReadSSLBuilder() {
        }

        public Object run() {
            String value = System.getProperty(Util.SSL_FACTORY_BUILDER);
            return value;
        }
    }

    static class SetAuthenticator
    implements PrivilegedAction {
        SetAuthenticator() {
        }

        public Object run() {
            Authenticator.setDefault((Authenticator)new SecurityAssociationAuthenticator());
            return null;
        }
    }
}

