/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.mdb;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Hashtable;
import javax.jms.Destination;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.annotation.ejb.MessageProperties;
import org.jboss.annotation.ejb.Producer;
import org.jboss.aop.advice.Interceptor;
import org.jboss.ejb3.NonSerializableFactory;
import org.jboss.ejb3.mdb.ConsumerContainer;
import org.jboss.ejb3.mdb.ProducerFactory;
import org.jboss.ejb3.mdb.ProducerManagerImpl;
import org.jboss.ejb3.mdb.ProducerObject;
import org.jboss.ejb3.mdb.ProducerProxy;

public class LocalProducerFactory
extends ProducerFactory {
    protected String factoryName;

    public LocalProducerFactory(ConsumerContainer container, Class producer, MessageProperties props, Destination dest, InitialContext ctx, Hashtable icProperties) {
        super(container, producer, props, dest, ctx, icProperties);
        try {
            this.factoryName = this.pImpl.connectionFactory();
            if (this.factoryName.equals("")) {
                this.factoryName = "java:/ConnectionFactory";
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object createProxy() {
        Class[] interfaces = new Class[]{this.producer, ProducerObject.class};
        ProducerManagerImpl mImpl = null;
        mImpl = new ProducerManagerImpl((Producer)this.pImpl, this.dest, this.factoryName, this.props.delivery(), this.props.timeToLive(), this.props.priority(), this.methodMap, this.initialContextProperties);
        Interceptor[] interceptors = new Interceptor[]{mImpl};
        ProducerProxy ih = new ProducerProxy(mImpl, interceptors);
        return Proxy.newProxyInstance(this.producer.getClassLoader(), interfaces, (InvocationHandler)ih);
    }

    public void start() throws Exception {
        super.start();
        try {
            NonSerializableFactory.rebind(this.ctx, this.jndiName + "PRODUCER_FACTORY", this);
        }
        catch (NamingException e) {
            NamingException namingException = new NamingException("Could not bind local producer factory with name " + this.factoryName + " into JNDI under jndiName: " + this.ctx.getNameInNamespace() + "/" + this.jndiName + "PRODUCER_FACTORY");
            namingException.setRootCause(e);
            throw namingException;
        }
    }

    public void stop() throws Exception {
        super.stop();
        NonSerializableFactory.unbind(this.ctx, this.jndiName + "PRODUCER_FACTORY");
    }
}

