/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.security.jacc.PolicyContext;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityAssociation;

public class SecurityActions {
    static ClassLoader getContextClassLoader() {
        return TCLAction.UTIL.getContextClassLoader();
    }

    static ClassLoader getContextClassLoader(Thread thread) {
        return TCLAction.UTIL.getContextClassLoader(thread);
    }

    static void setContextClassLoader(ClassLoader loader) {
        TCLAction.UTIL.setContextClassLoader(loader);
    }

    static void setContextClassLoader(Thread thread, ClassLoader loader) {
        TCLAction.UTIL.setContextClassLoader(thread, loader);
    }

    static String setContextID(String contextID) {
        SetContextID action = new SetContextID(contextID);
        String previousID = (String)AccessController.doPrivileged(action);
        return previousID;
    }

    public static RunAsIdentity peekRunAsIdentity(int depth) {
        PeekRunAsRoleAction action = new PeekRunAsRoleAction(depth);
        RunAsIdentity principal = (RunAsIdentity)AccessController.doPrivileged(action);
        return principal;
    }

    static interface TCLAction {
        public static final TCLAction NON_PRIVILEGED = new TCLAction(){

            public ClassLoader getContextClassLoader() {
                return Thread.currentThread().getContextClassLoader();
            }

            public ClassLoader getContextClassLoader(Thread thread) {
                return thread.getContextClassLoader();
            }

            public void setContextClassLoader(ClassLoader cl) {
                Thread.currentThread().setContextClassLoader(cl);
            }

            public void setContextClassLoader(Thread thread, ClassLoader cl) {
                thread.setContextClassLoader(cl);
            }
        };
        public static final TCLAction PRIVILEGED = new TCLAction(){
            private final PrivilegedAction getTCLPrivilegedAction = new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            };

            public ClassLoader getContextClassLoader() {
                return (ClassLoader)AccessController.doPrivileged(this.getTCLPrivilegedAction);
            }

            public ClassLoader getContextClassLoader(final Thread thread) {
                return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return thread.getContextClassLoader();
                    }
                });
            }

            public void setContextClassLoader(final ClassLoader cl) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(cl);
                        return null;
                    }
                });
            }

            public void setContextClassLoader(final Thread thread, final ClassLoader cl) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        thread.setContextClassLoader(cl);
                        return null;
                    }
                });
            }
        };

        public ClassLoader getContextClassLoader();

        public ClassLoader getContextClassLoader(Thread var1);

        public void setContextClassLoader(ClassLoader var1);

        public void setContextClassLoader(Thread var1, ClassLoader var2);

        public static class UTIL {
            static TCLAction getTCLAction() {
                return System.getSecurityManager() == null ? NON_PRIVILEGED : PRIVILEGED;
            }

            static ClassLoader getContextClassLoader() {
                return UTIL.getTCLAction().getContextClassLoader();
            }

            static ClassLoader getContextClassLoader(Thread thread) {
                return UTIL.getTCLAction().getContextClassLoader(thread);
            }

            static void setContextClassLoader(ClassLoader cl) {
                UTIL.getTCLAction().setContextClassLoader(cl);
            }

            static void setContextClassLoader(Thread thread, ClassLoader cl) {
                UTIL.getTCLAction().setContextClassLoader(thread, cl);
            }
        }
    }

    private static class PeekRunAsRoleAction
    implements PrivilegedAction {
        int depth;

        PeekRunAsRoleAction(int depth) {
            this.depth = depth;
        }

        public Object run() {
            RunAsIdentity principal = SecurityAssociation.peekRunAsIdentity((int)this.depth);
            return principal;
        }
    }

    private static class SetContextID
    implements PrivilegedAction {
        String contextID;

        SetContextID(String contextID) {
            this.contextID = contextID;
        }

        public Object run() {
            String previousID = PolicyContext.getContextID();
            PolicyContext.setContextID((String)this.contextID);
            return previousID;
        }
    }
}

