/* 
  
Copyright (C) since 2009 NTT DATA Corporation 
  
This program is free software; you can redistribute it and/or 
Modify it under the terms of the GNU General Public License  
as published by the Free Software Foundation, version 2. 
  
This program is distributed in the hope that it will be 
 useful, but WITHOUT ANY WARRANTY; without even the implied  
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR  
 PURPOSE.  See the GNU General Public License for more details. 
  
*/ 
package com.clustercontrol.repository.bean;

import java.io.Serializable;

/**
 * Data object for FacilityRelation.
 * @since 0.8
 */
public class FacilityRelationInfo implements Serializable
{
	
	private java.lang.String parentFacilityId;
	private java.lang.String childFacilityId;
	
	public FacilityRelationInfo()
	{
	}
	
	public FacilityRelationInfo( java.lang.String parentFacilityId,java.lang.String childFacilityId )
	{
		setParentFacilityId(parentFacilityId);
		setChildFacilityId(childFacilityId);
	}
	
	public FacilityRelationInfo( FacilityRelationInfo otherData )
	{
		setParentFacilityId(otherData.getParentFacilityId());
		setChildFacilityId(otherData.getChildFacilityId());
	}
	
	public java.lang.String getParentFacilityId()
	{
		return this.parentFacilityId;
	}
	public void setParentFacilityId( java.lang.String parentFacilityId )
	{
		this.parentFacilityId = parentFacilityId;
	}
	
	public java.lang.String getChildFacilityId()
	{
		return this.childFacilityId;
	}
	public void setChildFacilityId( java.lang.String childFacilityId )
	{
		this.childFacilityId = childFacilityId;
	}
	
	@Override
	public String toString()
	{
		StringBuffer str = new StringBuffer("{");
		
		str.append("parentFacilityId=" + getParentFacilityId() + " " + "childFacilityId=" + getChildFacilityId());
		str.append('}');
		
		return(str.toString());
	}
	
	@Override
	public boolean equals( Object pOther )
	{
		if( pOther instanceof FacilityRelationInfo )
		{
			FacilityRelationInfo lTest = (FacilityRelationInfo) pOther;
			boolean lEquals = true;
			
			if( this.parentFacilityId == null )
			{
				lEquals = lEquals && ( lTest.parentFacilityId == null );
			}
			else
			{
				lEquals = lEquals && this.parentFacilityId.equals( lTest.parentFacilityId );
			}
			if( this.childFacilityId == null )
			{
				lEquals = lEquals && ( lTest.childFacilityId == null );
			}
			else
			{
				lEquals = lEquals && this.childFacilityId.equals( lTest.childFacilityId );
			}
			
			return lEquals;
		}
		else
		{
			return false;
		}
	}
	
	@Override
	public int hashCode()
	{
		int result = 17;
		
		result = 37*result + ((this.parentFacilityId != null) ? this.parentFacilityId.hashCode() : 0);
		
		result = 37*result + ((this.childFacilityId != null) ? this.childFacilityId.hashCode() : 0);
		
		return result;
	}
}
